/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dialect.springdata.exception.InvalidObjectParameterException;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.IWebRequest;
import org.thymeleaf.web.servlet.IServletWebRequest;
import org.unbescape.html.HtmlEscape;

public final class PageUtils {
    private PageUtils() {
    }

    public static Page<?> findPage(ITemplateContext context) {
        Object pageFromLocalVariable = context.getVariable("_sd_.page.object");
        if (PageUtils.isPageInstance(pageFromLocalVariable)) {
            return (Page)pageFromLocalVariable;
        }
        IEngineConfiguration configuration = context.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
        IStandardExpression expression = parser.parseExpression((IExpressionContext)context, "${page}");
        Object page = expression.execute((IExpressionContext)context);
        if (PageUtils.isPageInstance(page)) {
            return (Page)page;
        }
        if (context instanceof IWebContext) {
            IWebExchange webExchange = ((IWebContext)context).getExchange();
            Set attrNames = webExchange.getAllAttributeNames();
            Page pageOnRequest = null;
            for (String attrName : attrNames) {
                Object attr = webExchange.getAttributeValue(attrName);
                if (!PageUtils.isPageInstance(attr)) continue;
                if (pageOnRequest != null) {
                    throw new InvalidObjectParameterException("More than one Page object found on request!");
                }
                pageOnRequest = (Page)attr;
            }
            if (pageOnRequest != null) {
                return pageOnRequest;
            }
        }
        throw new InvalidObjectParameterException("Invalid or not present Page object found on request!");
    }

    public static String createPageUrl(ITemplateContext context, int pageNumber) {
        String prefix = PageUtils.getParamPrefix(context);
        List<String> excludedParams = Arrays.asList(prefix.concat("page"));
        String baseUrl = PageUtils.buildBaseUrl(context, excludedParams);
        return PageUtils.buildUrl(baseUrl, context).append("page").append("=").append(pageNumber).toString();
    }

    public static String createSortUrl(ITemplateContext context, String fieldName, Sort.Direction forcedDir) {
        boolean hasPreviousOrder;
        String prefix = PageUtils.getParamPrefix(context);
        List<String> excludedParams = Arrays.asList(prefix.concat("sort"), prefix.concat("page"));
        String baseUrl = PageUtils.buildBaseUrl(context, excludedParams);
        StringBuilder sortParam = new StringBuilder();
        Page<?> page = PageUtils.findPage(context);
        Sort sort = page.getSort();
        boolean bl = hasPreviousOrder = sort != null && sort.getOrderFor(fieldName) != null;
        if (forcedDir != null) {
            sortParam.append(fieldName).append(",").append(forcedDir.toString().toLowerCase());
        } else if (hasPreviousOrder) {
            Sort.Order previousOrder = sort.getOrderFor(fieldName);
            Sort.Direction dir = previousOrder.isAscending() ? Sort.Direction.DESC : Sort.Direction.ASC;
            sortParam.append(fieldName).append(",").append(dir.toString().toLowerCase());
        } else {
            sortParam.append(fieldName);
        }
        return PageUtils.buildUrl(baseUrl, context).append("sort").append("=").append((CharSequence)sortParam).toString();
    }

    public static String createPageSizeUrl(ITemplateContext context, int pageSize) {
        String prefix = PageUtils.getParamPrefix(context);
        List<String> excludedParams = Arrays.asList(prefix.concat("size"), prefix.concat("page"));
        String baseUrl = PageUtils.buildBaseUrl(context, excludedParams);
        return PageUtils.buildUrl(baseUrl, context).append("size").append("=").append(pageSize).toString();
    }

    public static int getFirstItemInPage(Page<?> page) {
        return page.getSize() * page.getNumber() + 1;
    }

    public static int getLatestItemInPage(Page<?> page) {
        return page.getSize() * page.getNumber() + page.getNumberOfElements();
    }

    public static boolean isFirstPage(Page<?> page) {
        if (page.getTotalPages() == 0) {
            return true;
        }
        return page.isFirst();
    }

    public static boolean hasPrevious(Page<?> page) {
        return page.getTotalPages() > 0 && page.hasPrevious();
    }

    private static String buildBaseUrl(ITemplateContext context, Collection<String> excludeParams) {
        String url = (String)context.getVariable("_sd_.pagination.url");
        if (url == null && context instanceof IWebContext) {
            StringBuilder builder = new StringBuilder();
            IWebContext webContext = (IWebContext)context;
            IWebExchange webExchange = webContext.getExchange();
            IWebRequest request = webExchange.getRequest();
            builder.append(PageUtils.getRequestURI(request));
            Map params = request.getParameterMap();
            Set entries = params.entrySet();
            boolean firstParam = true;
            for (Map.Entry param : entries) {
                String name = (String)param.getKey();
                if (excludeParams.contains(name)) continue;
                if (firstParam) {
                    builder.append("?");
                    firstParam = false;
                } else {
                    builder.append("&");
                }
                String[] values = (String[])param.getValue();
                List<String> paramValues = Arrays.asList(values);
                Iterator it = paramValues.iterator();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    builder.append(name).append("=").append(value);
                    if (!it.hasNext()) continue;
                    builder.append("&");
                }
            }
            return HtmlEscape.escapeHtml4Xml((String)builder.toString());
        }
        return url == null ? "" : url;
    }

    private static String getRequestURI(IWebRequest webRequest) {
        if (webRequest instanceof IServletWebRequest) {
            IServletWebRequest servletWebRequest = (IServletWebRequest)webRequest;
            return servletWebRequest.getRequestURI();
        }
        String scheme = webRequest.getScheme();
        String serverName = webRequest.getServerName();
        Integer serverPort = webRequest.getServerPort();
        String requestPath = webRequest.getRequestPath();
        if (scheme != null && serverName != null && serverPort != null) {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(scheme).append("://").append(serverName);
            if (!(scheme.equals("http") && serverPort == 80 || scheme.equals("https") && serverPort == 443)) {
                urlBuilder.append(':').append(serverPort);
            }
            urlBuilder.append(requestPath);
            return urlBuilder.toString();
        }
        throw new UnsupportedOperationException("Request scheme, server name or port are null in this environment. Cannot compute request URL");
    }

    private static boolean isPageInstance(Object page) {
        return page != null && page instanceof Page;
    }

    private static StringBuilder buildUrl(String baseUrl, ITemplateContext context) {
        String paramAppender = String.valueOf(baseUrl).contains("?") ? "&" : "?";
        String prefix = PageUtils.getParamPrefix(context);
        return new StringBuilder(baseUrl).append(paramAppender).append(prefix);
    }

    private static String getParamPrefix(ITemplateContext context) {
        String prefix = (String)context.getVariable("_sd_.pagination.qualifier.prefix");
        return prefix == null ? "" : prefix.concat("_");
    }
}

