/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api.sys.mounts;

import java.util.Arrays;

public enum MountType {
    AWS("aws"),
    CONSUL("consul"),
    CUBBYHOLE("cubbyhole"),
    DATABASE("database"),
    KEY_VALUE("kv"),
    KEY_VALUE_V2("kv-v2"),
    IDENTITY("identity"),
    NOMAD("nomad"),
    PKI("pki"),
    RABBITMQ("rabbitmq"),
    SSH("ssh"),
    SYSTEM("system"),
    TOTP("totp"),
    TRANSIT("transit");

    private final String value;

    private MountType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static MountType of(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.stream(MountType.values()).filter(type -> type.value.equals(value)).findFirst().orElse(null);
    }
}

