/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.response;

import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.api.database.DatabaseCredential;
import io.github.jopenlibs.vault.api.database.DatabaseRoleOptions;
import io.github.jopenlibs.vault.json.JsonArray;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.response.LogicalResponse;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DatabaseResponse
extends LogicalResponse {
    private DatabaseCredential credential = this.buildCredentialFromData(this.getData());
    private DatabaseRoleOptions roleOptions = this.buildRoleOptionsFromData(this.getData(), this.getDataObject());

    public DatabaseCredential getCredential() {
        return this.credential;
    }

    public DatabaseRoleOptions getRoleOptions() {
        return this.roleOptions;
    }

    public DatabaseResponse(RestResponse restResponse, int retries) {
        super(restResponse, retries, Logical.logicalOperations.authentication);
    }

    private DatabaseRoleOptions buildRoleOptionsFromData(Map<String, String> data, JsonObject jsonObject) {
        if (data == null || data.size() == 0) {
            return null;
        }
        List<String> creationStatements = this.extractFromJsonArray(this.safeGetJsonArray(jsonObject, "creation_statements"));
        List<String> renewStatements = this.extractFromJsonArray(this.safeGetJsonArray(jsonObject, "renew_statements"));
        List<String> revocationStatements = this.extractFromJsonArray(this.safeGetJsonArray(jsonObject, "revocation_statements"));
        List<String> rollbackStatements = this.extractFromJsonArray(this.safeGetJsonArray(jsonObject, "rollback_statements"));
        String dbName = data.get("db_name");
        String defaultTtl = data.get("default_ttl");
        String maxTtl = data.get("default_ttl");
        if (dbName == null && defaultTtl == null && maxTtl == null) {
            return null;
        }
        return new DatabaseRoleOptions().creationStatements(creationStatements).renewStatements(renewStatements).revocationStatements(revocationStatements).rollbackStatements(rollbackStatements).dbName(dbName).defaultTtl(defaultTtl).maxTtl(maxTtl);
    }

    private DatabaseCredential buildCredentialFromData(Map<String, String> data) {
        if (data == null) {
            return null;
        }
        String username = data.get("username");
        String password = data.get("password");
        if (username == null && password == null) {
            return null;
        }
        return new DatabaseCredential().username(username).password(password);
    }

    private JsonArray safeGetJsonArray(JsonObject source, String key) {
        if (source == null || source.get(key) == null || source.get(key) == null || !source.get(key).isArray()) {
            return new JsonArray();
        }
        return source.get(key).asArray();
    }

    private List<String> extractFromJsonArray(JsonArray array) {
        ArrayList<String> result = new ArrayList<String>();
        array.forEach(entry -> result.add(entry.asString()));
        return result;
    }
}

