/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore.internal;

import io.github.joealisson.mmocore.ReadableBuffer;
import java.nio.ByteBuffer;

public class SinglePacketBuffer
implements ReadableBuffer {
    private final ByteBuffer buffer;

    public SinglePacketBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public char readChar() {
        return this.buffer.getChar();
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public void readBytes(byte[] dst) {
        this.buffer.get(dst);
    }

    @Override
    public void readBytes(byte[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public byte readByte(int index) {
        return this.buffer.get(index);
    }

    @Override
    public void writeByte(int index, byte value) {
        this.buffer.put(index, value);
    }

    @Override
    public short readShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public void writeShort(int index, short value) {
        this.buffer.putShort(index, value);
    }

    @Override
    public int limit() {
        return this.buffer.limit();
    }

    @Override
    public void limit(int newLimit) {
        this.buffer.limit(newLimit);
    }

    @Override
    public int readInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public void writeInt(int index, int value) {
        this.buffer.putInt(index, value);
    }
}

