/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class MMOThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public MMOThreadFactory(String name) {
        this.namePrefix = name + "-MMO-pool-" + poolNumber.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(null, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        thread.setPriority(10);
        thread.setDaemon(false);
        return thread;
    }
}

