/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore.internal;

import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.WritableBuffer;
import io.github.joealisson.mmocore.internal.ArrayPacketBuffer;
import io.github.joealisson.mmocore.internal.DynamicPacketBuffer;
import java.nio.ByteBuffer;

public abstract class InternalWritableBuffer
extends WritableBuffer {
    public abstract int position();

    public abstract void position(int var1);

    public abstract void mark();

    public abstract ByteBuffer[] toByteBuffers();

    public abstract void releaseResources();

    public static InternalWritableBuffer dynamicOf(ByteBuffer buffer, ResourcePool resourcePool) {
        return new DynamicPacketBuffer(buffer, resourcePool);
    }

    public static InternalWritableBuffer dynamicOf(ArrayPacketBuffer buffer, ResourcePool resourcePool) {
        DynamicPacketBuffer copy = new DynamicPacketBuffer(buffer.toByteBuffer(), resourcePool);
        copy.limit(buffer.limit());
        return copy;
    }

    public static InternalWritableBuffer arrayBacked(ResourcePool resourcePool) {
        return new ArrayPacketBuffer(resourcePool.getSegmentSize(), resourcePool);
    }
}

