/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferPool {
    private final Queue<ByteBuffer> buffers = new ConcurrentLinkedQueue<ByteBuffer>();
    private final int maxSize;
    private final int bufferSize;
    private final AtomicInteger elements = new AtomicInteger();

    public BufferPool(int maxSize, int bufferSize) {
        this.maxSize = maxSize;
        this.bufferSize = bufferSize;
    }

    public void initialize(float factor) {
        int amount = (int)Math.min((float)this.maxSize, (float)this.maxSize * factor);
        for (int i = 0; i < amount; ++i) {
            this.buffers.offer(ByteBuffer.allocateDirect(this.bufferSize).order(ByteOrder.LITTLE_ENDIAN));
        }
        this.elements.set(amount);
    }

    public void recycle(ByteBuffer buffer) {
        if (this.elements.get() < this.maxSize) {
            this.buffers.offer(buffer.clear());
            this.elements.incrementAndGet();
        }
    }

    public ByteBuffer get() {
        if (this.elements.get() > 0) {
            this.elements.getAndDecrement();
            return this.buffers.poll();
        }
        return null;
    }
}

