/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore.internal;

import io.github.joealisson.mmocore.ReadableBuffer;
import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.internal.InternalWritableBuffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class ArrayPacketBuffer
extends InternalWritableBuffer
implements ReadableBuffer {
    private final ResourcePool resourcePool;
    private byte[] data;
    private int index;
    private int limit;

    public ArrayPacketBuffer(int size, ResourcePool resourcePool) {
        this.data = new byte[size];
        this.resourcePool = resourcePool;
    }

    @Override
    public void writeByte(byte value) {
        this.writeByte(this.index++, value);
    }

    @Override
    public void writeByte(int index, byte value) {
        this.ensureSize(index + 1);
        this.data[index] = value;
    }

    private void ensureSize(int size) {
        if (this.data.length < size) {
            this.data = Arrays.copyOf(this.data, (int)((double)(this.data.length + size) * 1.2));
            this.limit = this.data.length;
        }
    }

    @Override
    public void writeBytes(byte[] bytes) {
        if (Objects.isNull(bytes)) {
            return;
        }
        this.ensureSize(this.index + bytes.length);
        System.arraycopy(bytes, 0, this.data, this.index, bytes.length);
        this.index += bytes.length;
    }

    @Override
    public void writeShort(short value) {
        this.writeShort(this.index, value);
        this.index += 2;
    }

    @Override
    public void writeShort(int index, short value) {
        this.ensureSize(index + 2);
        this.data[index++] = (byte)value;
        this.data[index] = (byte)(value >>> 8);
    }

    @Override
    public void writeChar(char value) {
        this.writeShort((short)value);
    }

    @Override
    public void writeInt(int value) {
        this.writeInt(this.index, value);
        this.index += 4;
    }

    @Override
    public void writeInt(int index, int value) {
        this.ensureSize(index + 4);
        this.data[index++] = (byte)value;
        this.data[index++] = (byte)(value >>> 8);
        this.data[index++] = (byte)(value >>> 16);
        this.data[index] = (byte)(value >>> 24);
    }

    @Override
    public void writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
    }

    @Override
    public void writeLong(long value) {
        this.ensureSize(this.index + 8);
        this.data[this.index++] = (byte)value;
        this.data[this.index++] = (byte)(value >>> 8);
        this.data[this.index++] = (byte)(value >>> 16);
        this.data[this.index++] = (byte)(value >>> 24);
        this.data[this.index++] = (byte)(value >>> 32);
        this.data[this.index++] = (byte)(value >>> 40);
        this.data[this.index++] = (byte)(value >>> 48);
        this.data[this.index++] = (byte)(value >>> 56);
    }

    @Override
    public void writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
    }

    @Override
    public int position() {
        return this.index;
    }

    @Override
    public void position(int pos) {
        this.index = pos;
    }

    @Override
    public byte readByte() {
        return this.data[this.index++];
    }

    @Override
    public byte readByte(int index) {
        return this.data[index];
    }

    @Override
    public short readShort() {
        return (short)(this.readUnsigned(this.index++) | this.readUnsigned(this.index++) << 8);
    }

    @Override
    public short readShort(int index) {
        return (short)(this.readUnsigned(index++) | this.readUnsigned(index) << 8);
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    private int readUnsigned(int index) {
        return Byte.toUnsignedInt(this.data[index]);
    }

    @Override
    public int readInt() {
        return this.readUnsigned(this.index++) | this.readUnsigned(this.index++) << 8 | this.readUnsigned(this.index++) << 16 | this.readUnsigned(this.index++) << 24;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public long readLong() {
        return Byte.toUnsignedLong(this.data[this.index++]) | Byte.toUnsignedLong(this.data[this.index++]) << 8 | Byte.toUnsignedLong(this.data[this.index++]) << 16 | Byte.toUnsignedLong(this.data[this.index++]) << 24 | Byte.toUnsignedLong(this.data[this.index++]) << 32 | Byte.toUnsignedLong(this.data[this.index++]) << 40 | Byte.toUnsignedLong(this.data[this.index++]) << 48 | Byte.toUnsignedLong(this.data[this.index++]) << 56;
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    @Override
    public void readBytes(byte[] dst, int offset, int length) {
        System.arraycopy(this.data, this.index, dst, offset, length);
        this.index += length;
    }

    @Override
    public int readInt(int index) {
        return this.readUnsigned(index++) | this.readUnsigned(index++) << 8 | this.readUnsigned(index++) << 16 | this.readUnsigned(index) << 24;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int newLimit) {
        this.ensureSize(newLimit);
        this.limit = newLimit;
    }

    @Override
    public void mark() {
        this.limit = this.index;
    }

    @Override
    public ByteBuffer[] toByteBuffers() {
        return new ByteBuffer[]{this.toByteBuffer()};
    }

    ByteBuffer toByteBuffer() {
        ByteBuffer buffer = this.resourcePool.getBuffer(this.limit);
        buffer.put(this.data, 0, this.limit);
        return buffer.flip();
    }

    @Override
    public void releaseResources() {
        this.index = 0;
        this.limit = this.data.length;
    }

    @Override
    public int remaining() {
        return this.limit - this.index;
    }
}

