/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import java.io.IOException;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteHandler<T extends Client<Connection<T>>>
implements CompletionHandler<Long, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteHandler.class);

    WriteHandler() {
    }

    @Override
    public void completed(Long result, T client) {
        if (result < 0L) {
            LOGGER.warn("Couldn't send data to client {}", client);
            if (((Client)client).isConnected()) {
                ((Client)client).disconnect();
            }
            return;
        }
        if (result < (long)((Client)client).getDataSentSize() && result > 0L) {
            LOGGER.debug("Still {} data to send. Trying to send", (Object)result);
            ((Client)client).resumeSend(result);
        } else {
            ((Client)client).finishWriting();
        }
    }

    @Override
    public void failed(Throwable e, T client) {
        if (!(e instanceof IOException)) {
            LOGGER.warn(e.getMessage(), e);
        }
        ((Client)client).disconnect();
    }
}

