/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.WritableBuffer;
import io.github.joealisson.mmocore.internal.ArrayPacketBuffer;
import io.github.joealisson.mmocore.internal.InternalWritableBuffer;
import java.util.Objects;

public abstract class WritablePacket<T extends Client<Connection<T>>> {
    private volatile boolean broadcast;
    private ArrayPacketBuffer broadcastCacheBuffer;

    protected WritablePacket() {
    }

    InternalWritableBuffer writeData(T client) {
        if (this.broadcast) {
            return this.writeDataWithCache(client);
        }
        return this.writeDataToBuffer(client);
    }

    private synchronized InternalWritableBuffer writeDataWithCache(T client) {
        if (Objects.nonNull(this.broadcastCacheBuffer)) {
            return InternalWritableBuffer.dynamicOf(this.broadcastCacheBuffer, ((Client)client).getResourcePool());
        }
        InternalWritableBuffer buffer = this.writeDataToBuffer(client);
        if (buffer instanceof ArrayPacketBuffer) {
            this.broadcastCacheBuffer = (ArrayPacketBuffer)buffer;
            return InternalWritableBuffer.dynamicOf(this.broadcastCacheBuffer, ((Client)client).getResourcePool());
        }
        return buffer;
    }

    private InternalWritableBuffer writeDataToBuffer(T client) {
        InternalWritableBuffer buffer = this.choosePacketBuffer(client);
        buffer.position(2);
        if (this.write(client, buffer)) {
            buffer.mark();
            return buffer;
        }
        buffer.releaseResources();
        return null;
    }

    private InternalWritableBuffer choosePacketBuffer(T client) {
        if (this.broadcast) {
            return InternalWritableBuffer.arrayBacked(((Client)client).getResourcePool());
        }
        return InternalWritableBuffer.dynamicOf(((Client)client).getResourcePool().getSegmentBuffer(), ((Client)client).getResourcePool());
    }

    void writeHeader(InternalWritableBuffer buffer, int header) {
        buffer.writeShort(0, (short)header);
    }

    public void sendInBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean canBeDropped(T client) {
        return false;
    }

    protected abstract boolean write(T var1, WritableBuffer var2);

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

