/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.internal.BufferPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcePool.class);
    private final Map<Integer, BufferPool> bufferPools;
    private int[] bufferSizes = new int[]{2, 64};
    private int bufferSegmentSize = 64;

    ResourcePool() {
        this.bufferPools = new HashMap<Integer, BufferPool>(4);
    }

    public ByteBuffer getHeaderBuffer() {
        return this.getSizedBuffer(2);
    }

    public ByteBuffer getSegmentBuffer() {
        return this.getSizedBuffer(this.bufferSegmentSize);
    }

    public ByteBuffer getBuffer(int size) {
        return this.getSizedBuffer(this.determineBufferSize(size));
    }

    public ByteBuffer recycleAndGetNew(ByteBuffer buffer, int newSize) {
        int bufferSize = this.determineBufferSize(newSize);
        if (Objects.nonNull(buffer)) {
            if (buffer.clear().limit() == bufferSize) {
                return buffer.limit(newSize);
            }
            this.recycleBuffer(buffer);
        }
        return this.getSizedBuffer(bufferSize).limit(newSize);
    }

    private ByteBuffer getSizedBuffer(int size) {
        BufferPool pool = this.bufferPools.get(size);
        ByteBuffer buffer = null;
        if (Objects.nonNull(pool)) {
            buffer = pool.get();
        }
        if (Objects.isNull(buffer)) {
            buffer = ByteBuffer.allocateDirect(size).order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer;
    }

    private int determineBufferSize(int size) {
        for (int bufferSize : this.bufferSizes) {
            if (size > bufferSize) continue;
            return bufferSize;
        }
        LOGGER.warn("There is no buffer pool handling buffer size {}", (Object)size);
        return size;
    }

    public void recycleBuffer(ByteBuffer buffer) {
        BufferPool pool;
        if (Objects.nonNull(buffer) && Objects.nonNull(pool = this.bufferPools.get(buffer.capacity()))) {
            pool.recycle(buffer);
        }
    }

    public int getSegmentSize() {
        return this.bufferSegmentSize;
    }

    public void addBufferPool(int bufferSize, BufferPool bufferPool) {
        this.bufferPools.putIfAbsent(bufferSize, bufferPool);
    }

    public int bufferPoolSize() {
        return this.bufferPools.size();
    }

    public void initializeBuffers(float initBufferPoolFactor) {
        if (initBufferPoolFactor > 0.0f) {
            this.bufferPools.values().forEach(pool -> pool.initialize(initBufferPoolFactor));
        }
        this.bufferSizes = this.bufferPools.keySet().stream().sorted().mapToInt(Integer::intValue).toArray();
    }

    public void setBufferSegmentSize(int size) {
        this.bufferSegmentSize = size;
    }
}

