/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ReadableBuffer;
import java.nio.charset.StandardCharsets;

public abstract class ReadablePacket<T extends Client<Connection<T>>>
implements Runnable {
    private ReadableBuffer buffer;
    protected T client;

    protected ReadablePacket() {
    }

    void init(T client, ReadableBuffer buffer) {
        this.client = client;
        this.buffer = buffer;
    }

    protected final int available() {
        return this.buffer.remaining();
    }

    protected final void readBytes(byte[] dst) {
        this.buffer.readBytes(dst, 0, dst.length);
    }

    protected final void readBytes(byte[] dst, int offset, int length) {
        this.buffer.readBytes(dst, offset, length);
    }

    protected final byte readByte() {
        return this.buffer.readByte();
    }

    protected final boolean readBoolean() {
        return this.readByte() != 0;
    }

    protected final char readChar() {
        return this.buffer.readChar();
    }

    protected final int readUnsignedByte() {
        return Byte.toUnsignedInt(this.readByte());
    }

    protected final short readShort() {
        return this.buffer.readShort();
    }

    protected final boolean readShortAsBoolean() {
        return this.readShort() != 0;
    }

    protected final float readFloat() {
        return this.buffer.readFloat();
    }

    protected final int readInt() {
        return this.buffer.readInt();
    }

    protected final boolean readIntAsBoolean() {
        return this.readInt() != 0;
    }

    protected final long readLong() {
        return this.buffer.readLong();
    }

    protected final double readDouble() {
        return this.buffer.readDouble();
    }

    protected final String readString() {
        char c;
        StringBuilder builder = new StringBuilder();
        while ((c = this.readChar()) != '\u0000') {
            builder.append(c);
        }
        return builder.toString();
    }

    protected final String readSizedString() {
        int size = this.readShort() * 2;
        byte[] data = new byte[size];
        this.readBytes(data);
        return new String(data, 0, size, StandardCharsets.UTF_16LE);
    }

    public T getClient() {
        return this.client;
    }

    protected abstract boolean read();
}

