/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.PacketExecutor;
import io.github.joealisson.mmocore.PacketHandler;
import io.github.joealisson.mmocore.ReadableBuffer;
import io.github.joealisson.mmocore.ReadablePacket;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadHandler<T extends Client<Connection<T>>>
implements CompletionHandler<Integer, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadHandler.class);
    private final PacketHandler<T> packetHandler;
    private final PacketExecutor<T> executor;

    ReadHandler(PacketHandler<T> packetHandler, PacketExecutor<T> executor) {
        this.packetHandler = packetHandler;
        this.executor = executor;
    }

    @Override
    public void completed(Integer bytesRead, T client) {
        if (!((Client)client).isConnected()) {
            return;
        }
        LOGGER.debug("Reading {} from {}", (Object)bytesRead, client);
        if (bytesRead < 0) {
            ((Client)client).disconnect();
            return;
        }
        if (bytesRead < ((Client)client).getExpectedReadSize()) {
            ((Client)client).resumeRead(bytesRead);
            return;
        }
        if (((Client)client).isReadingPayload()) {
            this.handlePayload(client);
        } else {
            this.handleHeader(client);
        }
    }

    private void handleHeader(T client) {
        ByteBuffer buffer = ((Connection)((Client)client).getConnection()).getReadingBuffer();
        buffer.flip();
        int dataSize = Short.toUnsignedInt(buffer.getShort()) - 2;
        ((Client)client).readPayload(dataSize);
    }

    private void handlePayload(T client) {
        ByteBuffer buffer = ((Connection)((Client)client).getConnection()).getReadingBuffer();
        buffer.flip();
        this.parseAndExecutePacket(client, buffer);
        ((Client)client).read();
    }

    private void parseAndExecutePacket(T client, ByteBuffer incomingBuffer) {
        LOGGER.debug("Trying to parse data");
        try {
            ReadableBuffer buffer = ReadableBuffer.of(incomingBuffer);
            boolean decrypted = ((Client)client).decrypt(buffer, 0, buffer.remaining());
            if (decrypted) {
                ReadablePacket<T> packet = this.packetHandler.handlePacket(buffer, client);
                LOGGER.debug("Data parsed to packet {}", packet);
                if (Objects.nonNull(packet)) {
                    packet.init(client, buffer);
                    this.execute(packet);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void execute(ReadablePacket<T> packet) {
        if (packet.read()) {
            LOGGER.debug("packet {} was read from client {}", packet, packet.client);
            this.executor.execute(packet);
        }
    }

    @Override
    public void failed(Throwable e, T client) {
        LOGGER.debug("Failed to read from {}", client, (Object)e);
        ((Client)client).disconnect();
    }
}

