/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ClientFactory;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionConfig;
import io.github.joealisson.mmocore.PacketExecutor;
import io.github.joealisson.mmocore.PacketHandler;
import io.github.joealisson.mmocore.ReadHandler;
import io.github.joealisson.mmocore.WriteHandler;
import io.github.joealisson.mmocore.internal.MMOThreadFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Connector<T extends Client<Connection<T>>> {
    private static final Object groupLock = new Object();
    private static AsynchronousChannelGroup group;
    private ConnectionConfig config;
    private ReadHandler<T> readHandler;
    private ClientFactory<T> clientFactory;

    public static <T extends Client<Connection<T>>> Connector<T> create(ClientFactory<T> clientFactory, PacketHandler<T> packetHandler, PacketExecutor<T> executor) {
        Connector<T> builder = new Connector<T>();
        builder.config = new ConnectionConfig(null);
        builder.readHandler = new ReadHandler<T>(packetHandler, executor);
        builder.clientFactory = clientFactory;
        return builder;
    }

    public Connector<T> addBufferPool(int size, int bufferSize) {
        this.config.newBufferGroup(size, bufferSize);
        return this;
    }

    public Connector<T> initBufferPoolFactor(float factor) {
        this.config.initBufferPoolFactor = factor;
        return this;
    }

    public Connector<T> bufferSegmentSize(int size) {
        this.config.resourcePool.setBufferSegmentSize(size);
        return this;
    }

    public Connector<T> dropPacketThreshold(int threshold) {
        this.config.dropPacketThreshold = threshold;
        return this;
    }

    public Connector<T> useCachedThreadPool(boolean cached) {
        this.config.useCachedThreadPool = cached;
        return this;
    }

    public Connector<T> threadPoolSize(int size) {
        this.config.threadPoolSize = size;
        return this;
    }

    public Connector<T> maxCachedThreads(int size) {
        this.config.maxCachedThreads = size;
        return this;
    }

    public T connect(String host, int port) throws IOException, ExecutionException, InterruptedException {
        InetSocketAddress socketAddress = Objects.isNull(host) || host.isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        return this.connect(socketAddress);
    }

    public T connect(InetSocketAddress socketAddress) throws IOException, ExecutionException, InterruptedException {
        this.createChannelGroup();
        AsynchronousSocketChannel channel = group.provider().openAsynchronousSocketChannel(group);
        channel.connect(socketAddress).get();
        Connection<T> connection = new Connection<T>(channel, this.readHandler, new WriteHandler(), this.config.complete());
        T client = this.clientFactory.create(connection);
        connection.setClient(client);
        ((Client)client).onConnected();
        ((Client)client).read();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createChannelGroup() throws IOException {
        if (Objects.isNull(group)) {
            Object object = groupLock;
            synchronized (object) {
                if (Objects.isNull(group)) {
                    if (this.config.useCachedThreadPool) {
                        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(this.config.threadPoolSize, this.config.maxCachedThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new MMOThreadFactory("Client"));
                        group = AsynchronousChannelGroup.withCachedThreadPool(threadPool, this.config.threadPoolSize);
                    } else {
                        group = AsynchronousChannelGroup.withFixedThreadPool(this.config.threadPoolSize, new MMOThreadFactory("Client"));
                    }
                }
            }
        }
    }
}

