/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ClientFactory;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionConfig;
import io.github.joealisson.mmocore.ReadHandler;
import io.github.joealisson.mmocore.WriteHandler;
import io.github.joealisson.mmocore.internal.MMOThreadFactory;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.Objects;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionHandler<T extends Client<Connection<T>>>
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionHandler.class);
    private final AsynchronousChannelGroup group;
    private final AsynchronousServerSocketChannel listener;
    private final ConnectionConfig config;
    private final WriteHandler<T> writeHandler;
    private final ReadHandler<T> readHandler;
    private final ClientFactory<T> clientFactory;
    private volatile boolean shutdown;

    ConnectionHandler(ConnectionConfig config, ClientFactory<T> clientFactory, ReadHandler<T> readHandler) throws IOException {
        this.setName("MMO-Networking");
        this.config = config;
        this.readHandler = readHandler;
        this.clientFactory = clientFactory;
        this.group = this.createChannelGroup();
        this.listener = this.group.provider().openAsynchronousServerSocketChannel(this.group);
        this.listener.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.listener.bind(config.address);
        this.writeHandler = new WriteHandler();
    }

    private AsynchronousChannelGroup createChannelGroup() throws IOException {
        if (this.config.useCachedThreadPool) {
            LOGGER.debug("Channel group is using CachedThreadPool");
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(this.config.threadPoolSize, this.config.maxCachedThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new MMOThreadFactory("Server"));
            return AsynchronousChannelGroup.withCachedThreadPool(threadPool, 0);
        }
        LOGGER.debug("Channel group is using FixedThreadPool");
        return AsynchronousChannelGroup.withFixedThreadPool(this.config.threadPoolSize, new MMOThreadFactory("Server"));
    }

    @Override
    public void run() {
        this.listener.accept(null, new AcceptConnectionHandler());
    }

    private void closeConnection() {
        try {
            this.listener.close();
            this.group.awaitTermination(this.config.shutdownWaitTime, TimeUnit.MILLISECONDS);
            this.group.shutdownNow();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        LOGGER.debug("Shutting ConnectionHandler down");
        this.shutdown = true;
        this.closeConnection();
    }

    private class AcceptConnectionHandler
    implements CompletionHandler<AsynchronousSocketChannel, Void> {
        private AcceptConnectionHandler() {
        }

        @Override
        public void completed(AsynchronousSocketChannel clientChannel, Void attachment) {
            this.tryAcceptNewConnection();
            this.acceptConnection(clientChannel);
        }

        private void tryAcceptNewConnection() {
            if (!ConnectionHandler.this.shutdown && ConnectionHandler.this.listener.isOpen()) {
                ConnectionHandler.this.listener.accept(null, this);
            }
        }

        @Override
        public void failed(Throwable t, Void attachment) {
            if (t instanceof ClosedChannelException) {
                LOGGER.debug(t.getMessage(), t);
            } else {
                this.tryAcceptNewConnection();
                LOGGER.warn(t.getMessage(), t);
            }
        }

        private void acceptConnection(AsynchronousSocketChannel channel) {
            if (Objects.nonNull(channel) && channel.isOpen()) {
                try {
                    LOGGER.debug("Accepting connection from {}", (Object)channel);
                    if (Objects.nonNull(ConnectionHandler.this.config.acceptFilter) && !ConnectionHandler.this.config.acceptFilter.accept(channel)) {
                        channel.close();
                        LOGGER.debug("Rejected connection");
                        return;
                    }
                    channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)(!ConnectionHandler.this.config.useNagle ? 1 : 0));
                    Connection connection = new Connection(channel, ConnectionHandler.this.readHandler, ConnectionHandler.this.writeHandler, ConnectionHandler.this.config);
                    Object client = ConnectionHandler.this.clientFactory.create(connection);
                    connection.setClient(client);
                    ((Client)client).onConnected();
                    ((Client)client).read();
                }
                catch (ClosedChannelException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    try {
                        channel.close();
                    }
                    catch (IOException ie) {
                        LOGGER.warn(ie.getMessage(), (Throwable)ie);
                    }
                }
            }
        }
    }
}

