/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.ConnectionFilter;
import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.internal.BufferPool;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ConnectionConfig {
    private static final int MINIMUM_POOL_GROUPS = 3;
    private static final Pattern BUFFER_POOL_PROPERTY = Pattern.compile("(bufferPool\\.\\w+?\\.)size", 2);
    public static final int HEADER_SIZE = 2;
    ResourcePool resourcePool;
    ConnectionFilter acceptFilter;
    SocketAddress address;
    float initBufferPoolFactor;
    long shutdownWaitTime = 5000L;
    int threadPoolSize;
    boolean useNagle;
    int dropPacketThreshold = 250;
    boolean useCachedThreadPool;
    int maxCachedThreads = Integer.MAX_VALUE;

    ConnectionConfig(SocketAddress address) {
        this.address = address;
        this.threadPoolSize = Math.max(2, Runtime.getRuntime().availableProcessors() - 2);
        this.resourcePool = new ResourcePool();
        this.resourcePool.addBufferPool(2, new BufferPool(100, 2));
        String systemProperty = System.getProperty("async-mmocore.configurationFile");
        if (Objects.nonNull(systemProperty) && !systemProperty.trim().isEmpty()) {
            this.loadProperties(systemProperty);
        }
    }

    private void loadProperties(String propertyFileName) {
        block9: {
            Path path = Paths.get(propertyFileName, new String[0]);
            try (InputStream inputStream = Files.isRegularFile(path, new LinkOption[0]) ? Files.newInputStream(path, new OpenOption[0]) : this.getClass().getResourceAsStream(propertyFileName);){
                if (Objects.nonNull(inputStream)) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    this.configure(properties);
                    break block9;
                }
                throw new IllegalArgumentException("Cannot find property file: " + propertyFileName);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read property file", e);
            }
        }
    }

    private void configure(Properties properties) {
        this.shutdownWaitTime = (long)this.parseInt(properties, "shutdownWaitTime", 5) * 1000L;
        this.useCachedThreadPool = this.parseBoolean(properties, "useCachedThreadPool", this.useCachedThreadPool);
        this.threadPoolSize = Math.max(1, this.parseInt(properties, "threadPoolSize", this.threadPoolSize));
        this.maxCachedThreads = this.parseInt(properties, "maxCachedThreads", this.maxCachedThreads);
        this.initBufferPoolFactor = this.parseFloat(properties, "bufferPool.initFactor", 0.0f);
        this.dropPacketThreshold = this.parseInt(properties, "dropPacketThreshold", 200);
        this.resourcePool.setBufferSegmentSize(this.parseInt(properties, "bufferSegmentSize", this.resourcePool.getSegmentSize()));
        properties.stringPropertyNames().forEach(property -> {
            Matcher matcher = BUFFER_POOL_PROPERTY.matcher((CharSequence)property);
            if (matcher.matches()) {
                int size = this.parseInt(properties, (String)property, 10);
                int bufferSize = this.parseInt(properties, matcher.group(1) + "bufferSize", 1024);
                this.newBufferGroup(size, bufferSize);
            }
        });
        this.newBufferGroup(100, this.resourcePool.getSegmentSize());
    }

    private boolean parseBoolean(Properties properties, String propertyName, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(properties.getProperty(propertyName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private int parseInt(Properties properties, String propertyName, int defaultValue) {
        try {
            return Integer.parseInt(properties.getProperty(propertyName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private float parseFloat(Properties properties, String propertyName, float defaultValue) {
        try {
            return Float.parseFloat(properties.getProperty(propertyName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void newBufferGroup(int groupSize, int bufferSize) {
        this.resourcePool.addBufferPool(bufferSize, new BufferPool(groupSize, bufferSize));
    }

    public ConnectionConfig complete() {
        this.completeBuffersPool();
        this.resourcePool.initializeBuffers(this.initBufferPoolFactor);
        return this;
    }

    private void completeBuffersPool() {
        int missingPools = 3 - this.resourcePool.bufferPoolSize();
        for (int i = 0; i < missingPools; ++i) {
            int bufferSize = 256 << i;
            this.resourcePool.addBufferPool(bufferSize, new BufferPool(10, bufferSize));
        }
    }
}

