/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ClientFactory;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionConfig;
import io.github.joealisson.mmocore.ConnectionFilter;
import io.github.joealisson.mmocore.ConnectionHandler;
import io.github.joealisson.mmocore.PacketExecutor;
import io.github.joealisson.mmocore.PacketHandler;
import io.github.joealisson.mmocore.ReadHandler;
import java.io.IOException;
import java.net.InetSocketAddress;

public class ConnectionBuilder<T extends Client<Connection<T>>> {
    private ConnectionConfig config;
    private ReadHandler<T> readerHandler;
    private ClientFactory<T> clientFactory;

    public static <T extends Client<Connection<T>>> ConnectionBuilder<T> create(InetSocketAddress address, ClientFactory<T> clientFactory, PacketHandler<T> packetHandler, PacketExecutor<T> executor) {
        ConnectionBuilder<T> builder = new ConnectionBuilder<T>();
        builder.config = new ConnectionConfig(address);
        builder.readerHandler = new ReadHandler<T>(packetHandler, executor);
        builder.clientFactory = clientFactory;
        return builder;
    }

    public ConnectionBuilder<T> filter(ConnectionFilter filter) {
        this.config.acceptFilter = filter;
        return this;
    }

    public ConnectionBuilder<T> useCachedThreadPool(boolean cached) {
        this.config.useCachedThreadPool = cached;
        return this;
    }

    public ConnectionBuilder<T> threadPoolSize(int size) {
        this.config.threadPoolSize = size;
        return this;
    }

    public ConnectionBuilder<T> maxCachedThreads(int size) {
        this.config.maxCachedThreads = size;
        return this;
    }

    public ConnectionBuilder<T> useNagle(boolean useNagle) {
        this.config.useNagle = useNagle;
        return this;
    }

    public ConnectionBuilder<T> shutdownWaitTime(long waitTime) {
        this.config.shutdownWaitTime = waitTime;
        return this;
    }

    public ConnectionBuilder<T> addBufferPool(int size, int bufferSize) {
        this.config.newBufferGroup(size, bufferSize);
        return this;
    }

    public ConnectionBuilder<T> initBufferPoolFactor(float factor) {
        this.config.initBufferPoolFactor = factor;
        return this;
    }

    public ConnectionBuilder<T> bufferSegmentSize(int size) {
        this.config.resourcePool.setBufferSegmentSize(size);
        return this;
    }

    public ConnectionBuilder<T> dropPacketThreshold(int threshold) {
        this.config.dropPacketThreshold = threshold;
        return this;
    }

    public ConnectionHandler<T> build() throws IOException {
        return new ConnectionHandler<T>(this.config.complete(), this.clientFactory, this.readerHandler);
    }
}

