/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ConnectionConfig;
import io.github.joealisson.mmocore.ReadHandler;
import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.WriteHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection<T extends Client<Connection<T>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final AsynchronousSocketChannel channel;
    private final ReadHandler<T> readHandler;
    private final WriteHandler<T> writeHandler;
    private final ConnectionConfig config;
    private T client;
    private ByteBuffer readingBuffer;
    private ByteBuffer[] writingBuffers;

    Connection(AsynchronousSocketChannel channel, ReadHandler<T> readHandler, WriteHandler<T> writeHandler, ConnectionConfig config) {
        this.channel = channel;
        this.readHandler = readHandler;
        this.writeHandler = writeHandler;
        this.config = config;
    }

    void setClient(T client) {
        this.client = client;
    }

    final void read() {
        if (this.channel.isOpen()) {
            this.channel.read(this.readingBuffer, this.client, this.readHandler);
        }
    }

    final void readHeader() {
        if (this.channel.isOpen()) {
            this.releaseReadingBuffer();
            this.readingBuffer = this.config.resourcePool.getHeaderBuffer();
            this.read();
        }
    }

    void read(int size) {
        if (this.channel.isOpen()) {
            this.readingBuffer = this.config.resourcePool.recycleAndGetNew(this.readingBuffer, size);
            this.read();
        }
    }

    final boolean write(ByteBuffer[] buffers) {
        if (!this.channel.isOpen()) {
            return false;
        }
        this.writingBuffers = buffers;
        this.write();
        return true;
    }

    final void write() {
        if (this.channel.isOpen() && Objects.nonNull(this.writingBuffers)) {
            this.channel.write(this.writingBuffers, 0, this.writingBuffers.length, -1L, TimeUnit.MILLISECONDS, this.client, this.writeHandler);
        } else if (Objects.nonNull(this.client)) {
            ((Client)this.client).finishWriting();
        }
    }

    ByteBuffer getReadingBuffer() {
        return this.readingBuffer;
    }

    private void releaseReadingBuffer() {
        if (Objects.nonNull(this.readingBuffer)) {
            this.config.resourcePool.recycleBuffer(this.readingBuffer);
            this.readingBuffer = null;
        }
    }

    boolean releaseWritingBuffer() {
        boolean released = false;
        if (Objects.nonNull(this.writingBuffers)) {
            for (ByteBuffer buffer : this.writingBuffers) {
                this.config.resourcePool.recycleBuffer(buffer);
                released = true;
            }
            this.writingBuffers = null;
        }
        return released;
    }

    void close() {
        this.releaseReadingBuffer();
        this.releaseWritingBuffer();
        try {
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.client = null;
        }
    }

    String getRemoteAddress() {
        try {
            InetSocketAddress address = (InetSocketAddress)this.channel.getRemoteAddress();
            return address.getAddress().getHostAddress();
        }
        catch (IOException e) {
            return "";
        }
    }

    boolean isOpen() {
        return this.channel.isOpen();
    }

    public ResourcePool getResourcePool() {
        return this.config.resourcePool;
    }

    public int dropPacketThreshold() {
        return this.config.dropPacketThreshold;
    }
}

