/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Buffer;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.WritablePacket;
import io.github.joealisson.mmocore.internal.InternalWritableBuffer;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client<T extends Connection<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Client.class);
    private final T connection;
    private final Queue<WritablePacket<? extends Client<T>>> packetsToWrite = new ConcurrentLinkedQueue<WritablePacket<? extends Client<T>>>();
    private final AtomicBoolean writing = new AtomicBoolean(false);
    private int estimateQueueSize = 0;
    private int dataSentSize;
    private volatile boolean isClosing;
    private boolean readingPayload;
    private int expectedReadSize;

    protected Client(T connection) {
        if (Objects.isNull(connection) || !((Connection)connection).isOpen()) {
            throw new IllegalArgumentException("The Connection is null or closed");
        }
        this.connection = connection;
    }

    protected final void writePacket(WritablePacket<? extends Client<T>> packet) {
        if (!this.isConnected() || Objects.isNull(packet) || this.packetCanBeDropped(packet)) {
            return;
        }
        ++this.estimateQueueSize;
        this.packetsToWrite.add(packet);
        this.writeFairPacket();
    }

    private boolean packetCanBeDropped(WritablePacket packet) {
        return this.estimateQueueSize > ((Connection)this.connection).dropPacketThreshold() && packet.canBeDropped(this);
    }

    protected final void writePackets(Collection<WritablePacket<? extends Client<T>>> packets) {
        if (!this.isConnected() || Objects.isNull(packets) || packets.isEmpty()) {
            return;
        }
        this.estimateQueueSize += packets.size();
        this.packetsToWrite.addAll(packets);
        this.writeFairPacket();
    }

    private void writeFairPacket() {
        if (this.writing.compareAndSet(false, true)) {
            FairnessController.sendFairPacket(this);
        }
    }

    private void writeNextPacket() {
        WritablePacket<? extends Client<T>> packet = this.packetsToWrite.poll();
        if (Objects.isNull(packet)) {
            this.releaseWritingResource();
            LOGGER.debug("There is no packet to send");
            if (this.isClosing) {
                this.disconnect();
            }
        } else {
            --this.estimateQueueSize;
            this.write(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(WritablePacket packet) {
        boolean written = false;
        InternalWritableBuffer buffer = null;
        try {
            buffer = packet.writeData(this);
            if (Objects.isNull(buffer)) {
                return;
            }
            int payloadSize = buffer.limit() - 2;
            if (payloadSize <= 0) {
                return;
            }
            if (this.encrypt(buffer, 2, payloadSize)) {
                this.dataSentSize = buffer.limit();
                if (this.dataSentSize <= 2) {
                    return;
                }
                packet.writeHeader(buffer, this.dataSentSize);
                written = ((Connection)this.connection).write(buffer.toByteBuffers());
                LOGGER.debug("Sending packet {}[{}] to {}", new Object[]{packet, this.dataSentSize, this});
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while {} writing {}", new Object[]{this, packet, e});
        }
        finally {
            if (!written) {
                this.handleNotWritten(buffer);
            }
        }
    }

    private void handleNotWritten(InternalWritableBuffer buffer) {
        if (!this.releaseWritingResource() && Objects.nonNull(buffer)) {
            buffer.releaseResources();
        }
        if (this.isConnected()) {
            this.writeFairPacket();
        }
    }

    void read() {
        this.expectedReadSize = 2;
        this.readingPayload = false;
        ((Connection)this.connection).readHeader();
    }

    void readPayload(int dataSize) {
        this.expectedReadSize = dataSize;
        this.readingPayload = true;
        ((Connection)this.connection).read(dataSize);
    }

    public void close() {
        this.close(null);
    }

    public void close(WritablePacket<? extends Client<T>> packet) {
        if (!this.isConnected()) {
            return;
        }
        this.packetsToWrite.clear();
        if (Objects.nonNull(packet)) {
            this.packetsToWrite.add(packet);
        }
        this.isClosing = true;
        LOGGER.debug("Closing client connection {} with packet {}", (Object)this, packet);
        this.writeFairPacket();
    }

    void resumeSend(long result) {
        this.dataSentSize = (int)((long)this.dataSentSize - result);
        ((Connection)this.connection).write();
    }

    void finishWriting() {
        ((Connection)this.connection).releaseWritingBuffer();
        FairnessController.sendFairPacket(this);
    }

    private boolean releaseWritingResource() {
        boolean released = ((Connection)this.connection).releaseWritingBuffer();
        this.writing.set(false);
        return released;
    }

    final void disconnect() {
        try {
            LOGGER.debug("Client {} disconnecting", (Object)this);
            this.onDisconnection();
        }
        finally {
            this.packetsToWrite.clear();
            ((Connection)this.connection).close();
        }
    }

    T getConnection() {
        return this.connection;
    }

    int getDataSentSize() {
        return this.dataSentSize;
    }

    public String getHostAddress() {
        return ((Connection)this.connection).getRemoteAddress();
    }

    public boolean isConnected() {
        return ((Connection)this.connection).isOpen() && !this.isClosing;
    }

    public int getEstimateQueueSize() {
        return this.estimateQueueSize;
    }

    ResourcePool getResourcePool() {
        return ((Connection)this.connection).getResourcePool();
    }

    boolean isReadingPayload() {
        return this.readingPayload;
    }

    void resumeRead(int bytesRead) {
        this.expectedReadSize -= bytesRead;
        ((Connection)this.connection).read();
    }

    int getExpectedReadSize() {
        return this.expectedReadSize;
    }

    public abstract boolean encrypt(Buffer var1, int var2, int var3);

    public abstract boolean decrypt(Buffer var1, int var2, int var3);

    protected abstract void onDisconnection();

    public abstract void onConnected();

    private static class FairnessController {
        private static final ConcurrentLinkedQueue<Client<?>> readyClients = new ConcurrentLinkedQueue();

        private FairnessController() {
        }

        private static void sendFairPacket(Client<?> client) {
            readyClients.offer(client);
            FairnessController.writeToNextClient();
        }

        private static void writeToNextClient() {
            Client<?> client = readyClients.poll();
            if (Objects.nonNull(client)) {
                client.writeNextPacket();
            }
        }
    }
}

