/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.ConnectionConfig;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class ResourcePool {
    private final Map<Integer, Queue<ByteBuffer>> buffers = new HashMap<Integer, Queue<ByteBuffer>>(4);
    private final ConnectionConfig<?> config;

    private ResourcePool(ConnectionConfig<?> config) {
        this.config = config;
    }

    ByteBuffer getPooledDirectBuffer() {
        return this.getSizedBuffer(this.config.bufferDefaultSize);
    }

    ByteBuffer getPooledDirectBuffer(int size) {
        return this.getSizedBuffer(this.determineBufferSize(size));
    }

    private ByteBuffer getSizedBuffer(int size) {
        Queue<ByteBuffer> queue = this.queueFromSize(size);
        ByteBuffer buffer = queue.poll();
        if (Objects.isNull(buffer)) {
            return ByteBuffer.allocateDirect(size).order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer;
    }

    private Queue<ByteBuffer> queueFromSize(int size) {
        Queue<ByteBuffer> queue = this.buffers.get(size);
        if (Objects.isNull(queue)) {
            queue = new ConcurrentLinkedQueue<ByteBuffer>();
            this.buffers.put(size, queue);
        }
        return queue;
    }

    private int determineBufferSize(int size) {
        int bufferSize = this.config.bufferDefaultSize;
        if (size <= this.config.bufferSmallSize) {
            bufferSize = this.config.bufferSmallSize;
        } else if (size <= this.config.bufferMediumSize) {
            bufferSize = this.config.bufferMediumSize;
        } else if (size <= this.config.bufferLargeSize) {
            bufferSize = this.config.bufferLargeSize;
        }
        return bufferSize;
    }

    void recycleBuffer(ByteBuffer buffer) {
        if (Objects.nonNull(buffer)) {
            int poolSize = this.determinePoolSize(buffer.capacity());
            Queue<ByteBuffer> queue = this.buffers.get(buffer.capacity());
            if (Objects.nonNull(queue) && queue.size() < poolSize) {
                buffer.clear();
                queue.add(buffer);
            }
        }
    }

    private int determinePoolSize(int size) {
        int poolSize = this.config.bufferPoolSize;
        if (size == this.config.bufferSmallSize) {
            poolSize = this.config.bufferSmallPoolSize;
        } else if (size == this.config.bufferMediumSize) {
            poolSize = this.config.bufferMediumPoolSize;
        } else if (size == this.config.bufferLargePoolSize) {
            poolSize = this.config.bufferLargePoolSize;
        }
        return poolSize;
    }

    int getSmallSize() {
        return this.config.bufferSmallSize;
    }

    static ResourcePool initialize(ConnectionConfig<?> config) {
        return new ResourcePool(config);
    }
}

