/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ClientFactory;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionFilter;
import io.github.joealisson.mmocore.ReadHandler;
import io.github.joealisson.mmocore.WriteHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;

class ConnectionConfig<T extends Client<Connection<T>>> {
    int bufferDefaultSize = 8192;
    int bufferSmallSize = 1024;
    int bufferMediumSize = 2048;
    int bufferLargeSize = 4096;
    int bufferPoolSize = 100;
    int bufferSmallPoolSize = 100;
    int bufferMediumPoolSize = 50;
    int bufferLargePoolSize = 25;
    long shutdownWaitTime = 5000L;
    int threadPoolSize;
    boolean useNagle;
    ClientFactory<T> clientFactory;
    ConnectionFilter acceptFilter;
    ReadHandler<T> readHandler;
    WriteHandler<T> writeHandler;
    SocketAddress address;

    ConnectionConfig(SocketAddress address, ClientFactory<T> factory, ReadHandler<T> readHandler) {
        this.address = address;
        this.clientFactory = factory;
        this.readHandler = readHandler;
        this.writeHandler = new WriteHandler();
        this.threadPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        String systemProperty = System.getProperty("async-mmocore.configurationFile");
        if (Objects.nonNull(systemProperty) && !systemProperty.trim().isEmpty()) {
            this.loadProperties(systemProperty);
        }
    }

    private void loadProperties(String propertyFileName) {
        block9: {
            Path path = Paths.get(propertyFileName, new String[0]);
            try (InputStream inputStream = Files.isRegularFile(path, new LinkOption[0]) ? Files.newInputStream(path, new OpenOption[0]) : this.getClass().getResourceAsStream(propertyFileName);){
                if (Objects.nonNull(inputStream)) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    this.configure(properties);
                    break block9;
                }
                throw new IllegalArgumentException("Cannot find property file: " + propertyFileName);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read property file", e);
            }
        }
    }

    private void configure(Properties properties) {
        this.bufferDefaultSize = this.parseInt(properties, "bufferDefaultSize", 8192);
        this.bufferSmallSize = this.parseInt(properties, "bufferSmallSize", 1024);
        this.bufferMediumSize = this.parseInt(properties, "bufferMediumSize", 2048);
        this.bufferLargeSize = this.parseInt(properties, "bufferLargeSize", 4096);
        this.bufferPoolSize = this.parseInt(properties, "bufferPoolSize", 100);
        this.bufferSmallPoolSize = this.parseInt(properties, "bufferSmallPoolSize", 100);
        this.bufferMediumPoolSize = this.parseInt(properties, "bufferMediumPoolSize", 50);
        this.bufferLargePoolSize = this.parseInt(properties, "bufferLargePoolSize", 25);
        this.shutdownWaitTime = (long)this.parseInt(properties, "shutdownWaitTime", 5) * 1000L;
        this.threadPoolSize = this.parseInt(properties, "threadPoolSize", this.threadPoolSize);
    }

    private int parseInt(Properties properties, String propertyName, int defaultValue) {
        try {
            return Integer.parseInt(properties.getProperty(propertyName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

