/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.PacketBuffer;
import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.WritablePacket;
import java.util.Arrays;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client<T extends Connection<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Client.class);
    static final int HEADER_SIZE = 2;
    private final T connection;
    private final Queue<WritablePacket<? extends Client<T>>> packetsToWrite = new ConcurrentLinkedQueue<WritablePacket<? extends Client<T>>>();
    private final AtomicBoolean writing = new AtomicBoolean(false);
    private int dataSentSize;
    private volatile boolean isClosing;
    private ResourcePool resourcePool;

    public Client(T connection) {
        if (Objects.isNull(connection) || !((Connection)connection).isOpen()) {
            throw new IllegalArgumentException("The Connection is null or closed");
        }
        this.connection = connection;
    }

    T getConnection() {
        return this.connection;
    }

    protected final void writePacket(WritablePacket<? extends Client<T>> packet) {
        if (!this.isConnected() || Objects.isNull(packet)) {
            return;
        }
        this.packetsToWrite.add(packet);
        this.tryWriteNextPacket();
    }

    private void tryWriteNextPacket() {
        LOGGER.debug("Trying to send next packet");
        if (this.writing.compareAndSet(false, true)) {
            if (this.packetsToWrite.isEmpty()) {
                ((Connection)this.connection).releaseWritingBuffer();
                this.writing.set(false);
                LOGGER.debug("no packet found");
                if (this.isClosing) {
                    this.disconnect();
                }
            } else {
                this.write(this.packetsToWrite.poll());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(WritablePacket packet) {
        try {
            int dataSize = packet.writeData(this);
            if (dataSize <= 0) {
                this.finishWriting();
                return;
            }
            int payloadSize = dataSize - 2;
            this.dataSentSize = this.encryptedSize(payloadSize) + 2;
            if (this.dataSentSize <= 2) {
                this.finishWriting();
                return;
            }
            this.encryptAndWrite(packet, payloadSize);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.finishWriting();
        }
        finally {
            packet.releaseData();
        }
    }

    private void encryptAndWrite(WritablePacket<? extends Client<T>> packet, int payloadSize) {
        PacketBuffer buffer = packet.buffer();
        if (this.dataSentSize > buffer.data.length) {
            buffer.data = Arrays.copyOf(buffer.data, this.dataSentSize);
        }
        buffer.data = this.encrypt(buffer.data, 2, payloadSize);
        packet.writeHeaderAndRecord(this.dataSentSize);
        ((Connection)this.connection).write(buffer.data, this.dataSentSize);
        LOGGER.debug("Sending packet {} to {}", packet, (Object)this);
    }

    public void close() {
        this.close(null);
    }

    public void close(WritablePacket<? extends Client<T>> packet) {
        if (!this.isConnected()) {
            return;
        }
        this.packetsToWrite.clear();
        if (Objects.nonNull(packet)) {
            this.packetsToWrite.add(packet);
        }
        this.isClosing = true;
        LOGGER.debug("Closing client connection {} with packet {}", (Object)this, packet);
        this.tryWriteNextPacket();
    }

    void resumeSend(int result) {
        this.dataSentSize -= result;
        ((Connection)this.connection).write();
    }

    void finishWriting() {
        this.writing.set(false);
        this.tryWriteNextPacket();
    }

    protected final void disconnect() {
        LOGGER.debug("Client {} disconnecting", (Object)this);
        this.onDisconnection();
        ((Connection)this.connection).close();
    }

    int getDataSentSize() {
        return this.dataSentSize;
    }

    public String getHostAddress() {
        return ((Connection)this.connection).getRemoteAddress();
    }

    public boolean isConnected() {
        return ((Connection)this.connection).isOpen() && !this.isClosing;
    }

    void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public abstract int encryptedSize(int var1);

    public abstract byte[] encrypt(byte[] var1, int var2, int var3);

    public abstract boolean decrypt(byte[] var1, int var2, int var3);

    protected abstract void onDisconnection();

    public abstract void onConnected();
}

