/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.PacketBuffer;
import io.github.joealisson.mmocore.StaticPacket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class WritablePacket<T extends Client<Connection<T>>> {
    private static final Map<Class<?>, Integer> packetInfo = new ConcurrentHashMap();
    private static final ThreadLocal<PacketBuffer> THREAD_LOCAL = new ThreadLocal();
    private byte[] staticData;

    protected WritablePacket() {
    }

    protected final void writeBytes(byte ... bytes) {
        if (Objects.isNull(bytes)) {
            return;
        }
        PacketBuffer buffer = THREAD_LOCAL.get();
        this.ensureSize(buffer, bytes.length);
        System.arraycopy(bytes, 0, buffer.data, buffer.index, bytes.length);
        buffer.index += bytes.length;
    }

    private void ensureSize(PacketBuffer buffer, int size) {
        if (buffer.data.length < buffer.index + size) {
            buffer.data = Arrays.copyOf(buffer.data, (int)((double)(buffer.data.length + size) * 1.2));
        }
    }

    protected final void writeByte(byte value) {
        PacketBuffer buffer = THREAD_LOCAL.get();
        this.ensureSize(buffer, 1);
        buffer.data[buffer.index++] = value;
    }

    protected final void writeByte(int value) {
        this.writeByte((byte)value);
    }

    protected final void writeByte(boolean value) {
        this.writeByte((byte)(value ? 1 : 0));
    }

    protected final void writeDouble(double value) {
        long x = Double.doubleToRawLongBits(value);
        this.writeLong(x);
    }

    protected final void writeShort(int value) {
        this.writeBytes((byte)value, (byte)(value >>> 8));
    }

    protected final void writeShort(boolean value) {
        this.writeShort(value ? 1 : 0);
    }

    protected final void writeInt(int value) {
        this.writeBytes((byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24));
    }

    protected final void writeInt(boolean value) {
        this.writeInt(value ? 1 : 0);
    }

    protected final void writeFloat(float value) {
        int x = Float.floatToRawIntBits(value);
        this.writeInt(x);
    }

    protected final void writeLong(long value) {
        this.writeBytes((byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24), (byte)(value >>> 32), (byte)(value >>> 40), (byte)(value >>> 48), (byte)(value >>> 56));
    }

    protected final void writeChar(char value) {
        this.writeBytes((byte)value, (byte)(value >>> 8));
    }

    protected final void writeString(CharSequence text) {
        if (Objects.isNull(text)) {
            this.writeChar('\u0000');
            return;
        }
        this.writeStringWithCharset(text);
        this.writeChar('\u0000');
    }

    private void writeStringWithCharset(CharSequence text) {
        this.writeBytes(text.toString().getBytes(StandardCharsets.UTF_16LE));
    }

    protected final void writeSizedString(CharSequence text) {
        if (Objects.nonNull(text) && text.length() > 0) {
            this.writeShort(text.length());
            this.writeStringWithCharset(text);
        } else {
            this.writeShort(0);
        }
    }

    int writeData(T client) {
        if (this.hasWritedStaticData()) {
            THREAD_LOCAL.set(PacketBuffer.of(Arrays.copyOf(this.staticData, this.staticData.length), this.staticData.length));
            return this.staticData.length;
        }
        THREAD_LOCAL.set(PacketBuffer.of(packetInfo.getOrDefault(this.getClass(), ((Client)client).getResourcePool().getSmallSize())));
        if (this.write(client)) {
            PacketBuffer buffer = THREAD_LOCAL.get();
            if (this.getClass().isAnnotationPresent(StaticPacket.class)) {
                this.staticData = Arrays.copyOf(buffer.data, buffer.index);
            }
            return buffer.index;
        }
        return 0;
    }

    void writeHeaderAndRecord(int header) {
        PacketBuffer buffer = THREAD_LOCAL.get();
        short size = (short)header;
        buffer.data[0] = (byte)size;
        buffer.data[1] = (byte)(size >>> 8);
        packetInfo.compute(this.getClass(), (k, v) -> Objects.isNull(v) ? header : Math.max(v, header));
    }

    private boolean hasWritedStaticData() {
        return this.getClass().isAnnotationPresent(StaticPacket.class) && Objects.nonNull(this.staticData);
    }

    PacketBuffer buffer() {
        return THREAD_LOCAL.get();
    }

    void releaseData() {
        THREAD_LOCAL.remove();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected abstract boolean write(T var1);
}

