/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.PacketBuffer;
import java.nio.charset.StandardCharsets;

public abstract class ReadablePacket<T extends Client<Connection<T>>>
implements Runnable {
    private PacketBuffer buffer;
    protected T client;

    protected ReadablePacket() {
    }

    void init(T client, PacketBuffer buffer) {
        this.client = client;
        this.buffer = buffer;
    }

    protected final int available() {
        return this.buffer.data.length - this.buffer.index;
    }

    protected final void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    protected final void readBytes(byte[] dst, int offset, int length) {
        System.arraycopy(this.buffer.data, this.buffer.index, dst, offset, length);
        this.buffer.index += length;
    }

    protected final byte readByte() {
        return this.buffer.data[this.buffer.index++];
    }

    protected final boolean readBoolean() {
        return this.readByte() != 0;
    }

    protected final char readChar() {
        return (char)this.readShort();
    }

    protected final int readUnsignedByte() {
        return Byte.toUnsignedInt(this.buffer.data[this.buffer.index++]);
    }

    protected final short readShort() {
        return (short)(this.readUnsignedByte() | this.readUnsignedByte() << 8);
    }

    protected final boolean readShortAsBoolean() {
        return this.readShort() != 0;
    }

    protected final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    protected final int readInt() {
        return this.readUnsignedByte() | this.readUnsignedByte() << 8 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 24;
    }

    protected final boolean readIntAsBoolean() {
        return this.readInt() != 0;
    }

    protected final long readLong() {
        return Byte.toUnsignedLong(this.readByte()) | Byte.toUnsignedLong(this.readByte()) << 8 | Byte.toUnsignedLong(this.readByte()) << 16 | Byte.toUnsignedLong(this.readByte()) << 24 | Byte.toUnsignedLong(this.readByte()) << 32 | Byte.toUnsignedLong(this.readByte()) << 40 | Byte.toUnsignedLong(this.readByte()) << 48 | Byte.toUnsignedLong(this.readByte()) << 56;
    }

    protected final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    protected final String readString() {
        char c;
        StringBuilder builder = new StringBuilder();
        while ((c = this.readChar()) != '\u0000') {
            builder.append(c);
        }
        return builder.toString();
    }

    protected final String readSizedString() {
        int size = this.readShort() * 2;
        byte[] data = new byte[size];
        this.readBytes(data);
        return new String(data, 0, size, StandardCharsets.UTF_16LE);
    }

    public T getClient() {
        return this.client;
    }

    protected abstract boolean read();
}

