/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionConfig;
import io.github.joealisson.mmocore.ResourcePool;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionHandler<T extends Client<Connection<T>>>
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionHandler.class);
    private static final int CACHED_THREAD_POLL_THRESHOLD = 1000;
    private final AsynchronousChannelGroup group;
    private final AsynchronousServerSocketChannel listener;
    private final ConnectionConfig<T> config;
    private volatile boolean shutdown;
    private final ResourcePool resourcePool;

    ConnectionHandler(ConnectionConfig<T> config) throws IOException {
        this.config = config;
        this.resourcePool = ResourcePool.initialize(config);
        this.group = this.createChannelGroup(config.threadPoolSize);
        this.listener = this.group.provider().openAsynchronousServerSocketChannel(this.group);
        this.listener.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.listener.bind(config.address);
    }

    private AsynchronousChannelGroup createChannelGroup(int threadPoolSize) throws IOException {
        if (threadPoolSize <= 0 || threadPoolSize >= 1000) {
            LOGGER.debug("Channel group is using CachedThreadPool");
            return AsynchronousChannelGroup.withCachedThreadPool(new ThreadPoolExecutor(0, Short.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>()), Runtime.getRuntime().availableProcessors());
        }
        LOGGER.debug("Channel group is using FixedThreadPool");
        return AsynchronousChannelGroup.withFixedThreadPool(threadPoolSize, Executors.defaultThreadFactory());
    }

    @Override
    public void run() {
        this.listener.accept(null, new AcceptConnectionHandler());
    }

    private void closeConnection() {
        try {
            this.listener.close();
            this.group.awaitTermination(this.config.shutdownWaitTime, TimeUnit.MILLISECONDS);
            this.group.shutdownNow();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        LOGGER.debug("Shutting ConnectionHandler down");
        this.shutdown = true;
        this.closeConnection();
    }

    private class AcceptConnectionHandler
    implements CompletionHandler<AsynchronousSocketChannel, Void> {
        private AcceptConnectionHandler() {
        }

        @Override
        public void completed(AsynchronousSocketChannel clientChannel, Void attachment) {
            this.tryAcceptNewConnection();
            this.acceptConnection(clientChannel);
        }

        private void tryAcceptNewConnection() {
            if (!ConnectionHandler.this.shutdown && ConnectionHandler.this.listener.isOpen()) {
                ConnectionHandler.this.listener.accept(null, this);
            }
        }

        @Override
        public void failed(Throwable t, Void attachment) {
            if (t instanceof ClosedChannelException) {
                LOGGER.debug(t.getMessage(), t);
            } else {
                this.tryAcceptNewConnection();
                LOGGER.warn(t.getMessage(), t);
            }
        }

        private void acceptConnection(AsynchronousSocketChannel channel) {
            if (Objects.nonNull(channel) && channel.isOpen()) {
                try {
                    LOGGER.debug("Accepting connection from {}", (Object)channel);
                    if (Objects.nonNull(ConnectionHandler.this.config.acceptFilter) && !ConnectionHandler.this.config.acceptFilter.accept(channel)) {
                        channel.close();
                        LOGGER.debug("Rejected connection");
                        return;
                    }
                    channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)(!ConnectionHandler.this.config.useNagle ? 1 : 0));
                    Connection connection = new Connection(channel, ConnectionHandler.this.config.readHandler, ConnectionHandler.this.config.writeHandler);
                    Object client = ConnectionHandler.this.config.clientFactory.create(connection);
                    ((Client)client).setResourcePool(ConnectionHandler.this.resourcePool);
                    connection.setClient(client);
                    ((Client)client).onConnected();
                    connection.read();
                }
                catch (ClosedChannelException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    try {
                        channel.close();
                    }
                    catch (IOException ie) {
                        LOGGER.warn(ie.getMessage(), (Throwable)ie);
                    }
                }
            }
        }
    }
}

