/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.StaticPacket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public abstract class WritablePacket<T extends Client<Connection<T>>> {
    private byte[] staticData;

    protected WritablePacket() {
    }

    protected final void writeString(CharSequence text, ByteBuffer buffer) {
        if (Objects.isNull(text)) {
            buffer.putChar('\u0000');
            return;
        }
        this.writeStringWithCharset(text, buffer);
        buffer.putChar('\u0000');
    }

    private void writeStringWithCharset(CharSequence text, ByteBuffer buffer) {
        Charset charset = buffer.order() == ByteOrder.BIG_ENDIAN ? StandardCharsets.UTF_16BE : StandardCharsets.UTF_16LE;
        buffer.put(text.toString().getBytes(charset));
    }

    protected final void writeSizedString(CharSequence text, ByteBuffer buffer) {
        if (Objects.nonNull(text) && text.length() > 0) {
            buffer.putShort((short)text.length());
            this.writeStringWithCharset(text, buffer);
        } else {
            buffer.putShort((short)0);
        }
    }

    int writeData(T client, ByteBuffer buffer) {
        if (this.hasWritedStaticData()) {
            return this.writedStaticData(buffer);
        }
        if (this.write(client, buffer)) {
            int dataPos = buffer.position();
            if (this.getClass().isAnnotationPresent(StaticPacket.class)) {
                this.staticData = new byte[dataPos];
                buffer.rewind();
                buffer.get(this.staticData);
            }
            return dataPos;
        }
        return 0;
    }

    private int writedStaticData(ByteBuffer buffer) {
        buffer.clear();
        buffer.put(this.staticData);
        return this.staticData.length;
    }

    private boolean hasWritedStaticData() {
        return this.getClass().isAnnotationPresent(StaticPacket.class) && Objects.nonNull(this.staticData);
    }

    protected int size(T client) {
        return -1;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected abstract boolean write(T var1, ByteBuffer var2);
}

