/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.ConnectionConfig;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class ResourcePool {
    private final Map<Integer, Queue<ByteBuffer>> directBuffers = new HashMap<Integer, Queue<ByteBuffer>>();
    private final Map<Integer, Queue<ByteBuffer>> buffers = new HashMap<Integer, Queue<ByteBuffer>>();
    private final ConnectionConfig config;

    private ResourcePool(ConnectionConfig config) {
        this.config = config;
    }

    ByteBuffer getPooledDirectBuffer() {
        return this.getSizedBuffer(this.config.bufferDefaultSize, true);
    }

    ByteBuffer getPooledBuffer() {
        return this.getSizedBuffer(this.config.bufferDefaultSize, false);
    }

    ByteBuffer getPooledDirectBuffer(int size) {
        return this.getSizedBuffer(this.determineBufferSize(size), true);
    }

    ByteBuffer getPooledBuffer(int size) {
        return this.getSizedBuffer(this.determineBufferSize(size), false);
    }

    private ByteBuffer getSizedBuffer(int size, boolean direct) {
        Queue<ByteBuffer> queue = this.queueFromSize(size, direct);
        ByteBuffer buffer = queue.poll();
        if (Objects.isNull(buffer)) {
            return direct ? ByteBuffer.allocateDirect(size).order(this.config.byteOrder) : ByteBuffer.allocate(size).order(this.config.byteOrder);
        }
        return buffer;
    }

    private Queue<ByteBuffer> queueFromSize(int size, boolean direct) {
        Queue<ByteBuffer> queue;
        Queue<ByteBuffer> queue2 = queue = direct ? this.directBuffers.get(size) : this.buffers.get(size);
        if (Objects.isNull(queue)) {
            queue = new ConcurrentLinkedQueue<ByteBuffer>();
            if (direct) {
                this.directBuffers.put(size, queue);
            } else {
                this.buffers.put(size, queue);
            }
        }
        return queue;
    }

    private int determineBufferSize(int size) {
        int bufferSize = this.config.bufferDefaultSize;
        if (size <= this.config.bufferSmallSize) {
            bufferSize = this.config.bufferSmallSize;
        } else if (size <= this.config.bufferMediumSize) {
            bufferSize = this.config.bufferMediumSize;
        } else if (size <= this.config.bufferLargeSize) {
            bufferSize = this.config.bufferLargeSize;
        }
        return bufferSize;
    }

    void recycleBuffer(ByteBuffer buffer) {
        if (Objects.nonNull(buffer)) {
            int poolSize = this.determinePoolSize(buffer.capacity());
            Queue<ByteBuffer> queue = buffer.isDirect() ? this.directBuffers.get(buffer.capacity()) : this.buffers.get(buffer.capacity());
            if (Objects.nonNull(queue) && queue.size() < poolSize) {
                buffer.clear();
                queue.add(buffer);
            }
        }
    }

    private int determinePoolSize(int size) {
        int poolSize = this.config.bufferPoolSize;
        if (size == this.config.bufferSmallSize) {
            poolSize = this.config.bufferSmallPoolSize;
        } else if (size == this.config.bufferMediumSize) {
            poolSize = this.config.bufferMediumPoolSize;
        } else if (size == this.config.bufferLargePoolSize) {
            poolSize = this.config.bufferLargePoolSize;
        }
        return poolSize;
    }

    static ResourcePool initialize(ConnectionConfig config) {
        return new ResourcePool(config);
    }
}

