/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class ReadablePacket<T extends Client<Connection<T>>>
implements Runnable {
    protected T client;

    protected ReadablePacket() {
    }

    protected final String readString(ByteBuffer buffer) {
        char c;
        StringBuilder builder = new StringBuilder();
        while ((c = buffer.getChar()) != '\u0000') {
            builder.append(c);
        }
        return builder.toString();
    }

    protected final String readSizedString(ByteBuffer buffer) {
        int size = buffer.getShort() * 2;
        byte[] data = new byte[size];
        buffer.get(data);
        Charset charset = buffer.order() == ByteOrder.BIG_ENDIAN ? StandardCharsets.UTF_16BE : StandardCharsets.UTF_16LE;
        return new String(data, 0, size, charset);
    }

    public T getClient() {
        return this.client;
    }

    protected abstract boolean read(ByteBuffer var1);
}

