/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.PacketExecutor;
import io.github.joealisson.mmocore.PacketHandler;
import io.github.joealisson.mmocore.ReadablePacket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CompletionHandler;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadHandler<T extends Client<Connection<T>>>
implements CompletionHandler<Integer, T> {
    private static final Logger logger = LoggerFactory.getLogger(ReadHandler.class);
    private final PacketHandler<T> packetHandler;
    private final PacketExecutor<T> executor;

    ReadHandler(PacketHandler<T> packetHandler, PacketExecutor<T> executor) {
        this.packetHandler = packetHandler;
        this.executor = executor;
    }

    @Override
    public void completed(Integer bytesRead, T client) {
        if (!((Client)client).isConnected()) {
            return;
        }
        logger.debug("Reading {} from {}", (Object)bytesRead, client);
        if (bytesRead < 0) {
            ((Client)client).disconnect();
            return;
        }
        this.readData(client);
    }

    private void readData(T client) {
        Object connection = ((Client)client).getConnection();
        ByteBuffer buffer = ((Connection)connection).getReadingBuffer();
        buffer.flip();
        if (buffer.remaining() < 2) {
            logger.debug("Not enough data to read packet header");
            buffer.compact();
            ((Connection)connection).read();
            return;
        }
        int dataSize = Short.toUnsignedInt(buffer.getShort()) - 2;
        if (dataSize > buffer.remaining()) {
            logger.debug("Not enough data to read. Packet size {}", (Object)dataSize);
            buffer.position(buffer.position() - 2);
            buffer.compact();
            ((Connection)connection).read();
            return;
        }
        this.onCompleteRead(client, (Connection<T>)connection, buffer, dataSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompleteRead(T client, Connection<T> connection, ByteBuffer buffer, int dataSize) {
        boolean continueReading = true;
        try {
            if (dataSize > 0) {
                this.parseAndExecutePacket(client, buffer, dataSize);
                if (!buffer.hasRemaining()) {
                    buffer.clear();
                } else {
                    logger.debug("Still data on packet. Trying to read");
                    int remaining = buffer.remaining();
                    buffer.compact();
                    if (remaining >= 2) {
                        this.completed(remaining, client);
                        continueReading = false;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            buffer.clear();
        }
        finally {
            if (continueReading) {
                connection.read();
            }
        }
    }

    private void parseAndExecutePacket(T client, ByteBuffer incomingBuffer, int dataSize) {
        logger.debug("Trying to parse data");
        ByteBuffer buffer = ((Client)client).getResourcePool().getPooledBuffer(dataSize);
        int limit = incomingBuffer.limit();
        incomingBuffer.limit(incomingBuffer.position() + dataSize);
        buffer.put(incomingBuffer);
        incomingBuffer.limit(limit);
        boolean decrypted = ((Client)client).decrypt(buffer.array(), 0, dataSize);
        if (decrypted) {
            buffer.flip();
            ReadablePacket<T> packet = this.packetHandler.handlePacket(buffer, client);
            logger.debug("Data parsed to packet {}", packet);
            if (Objects.nonNull(packet)) {
                packet.client = client;
                this.execute(packet, buffer);
            }
        }
    }

    private void execute(ReadablePacket<T> packet, ByteBuffer buffer) {
        if (packet.read(buffer)) {
            logger.debug("packet {} was read from client {}", packet, packet.client);
            this.executor.execute(packet);
        }
    }

    @Override
    public void failed(Throwable e, T client) {
        if (((Client)client).isConnected()) {
            ((Client)client).disconnect();
        }
        if (!(e instanceof AsynchronousCloseException)) {
            logger.error(e.getLocalizedMessage(), e);
        }
    }
}

