/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ClientFactory;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionConfig;
import io.github.joealisson.mmocore.PacketExecutor;
import io.github.joealisson.mmocore.PacketHandler;
import io.github.joealisson.mmocore.ReadHandler;
import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.WriteHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;

public class Connector<T extends Client<Connection<T>>> {
    private ConnectionConfig<T> config;
    private static final int THREAD_POOL_SIZE = 2;

    public static <T extends Client<Connection<T>>> Connector<T> create(ClientFactory<T> clientFactory, PacketHandler<T> packetHandler, PacketExecutor<T> executor) {
        Connector<T> builder = new Connector<T>();
        builder.config = new ConnectionConfig<T>(null, clientFactory, new ReadHandler<T>(packetHandler, executor));
        return builder;
    }

    public Connector<T> bufferDefaultSize(int bufferSize) {
        this.config.bufferDefaultSize = bufferSize;
        return this;
    }

    public Connector<T> bufferSmallSize(int bufferSize) {
        this.config.bufferSmallSize = bufferSize;
        return this;
    }

    public Connector<T> bufferMediumSize(int bufferSize) {
        this.config.bufferMediumSize = bufferSize;
        return this;
    }

    public Connector<T> bufferLargeSize(int bufferSize) {
        this.config.bufferLargeSize = bufferSize;
        return this;
    }

    public Connector<T> bufferPoolSize(int bufferPoolSize) {
        this.config.bufferPoolSize = bufferPoolSize;
        return this;
    }

    public Connector<T> bufferSmallPoolSize(int bufferPoolSize) {
        this.config.bufferSmallPoolSize = bufferPoolSize;
        return this;
    }

    public Connector<T> bufferMediumPoolSize(int bufferPoolSize) {
        this.config.bufferMediumPoolSize = bufferPoolSize;
        return this;
    }

    public Connector<T> bufferLargePoolSize(int bufferPoolSize) {
        this.config.bufferLargePoolSize = bufferPoolSize;
        return this;
    }

    public Connector<T> byteOrder(ByteOrder order) {
        this.config.byteOrder = order;
        return this;
    }

    public T connect(String host, int port) throws IOException, ExecutionException, InterruptedException {
        InetSocketAddress socketAddress = Objects.isNull(host) || host.isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        return this.connect(socketAddress);
    }

    public T connect(InetSocketAddress socketAddress) throws IOException, ExecutionException, InterruptedException {
        AsynchronousChannelGroup group = AsynchronousChannelGroup.withFixedThreadPool(2, Executors.defaultThreadFactory());
        AsynchronousSocketChannel channel = group.provider().openAsynchronousSocketChannel(group);
        channel.connect(socketAddress).get();
        Connection connection = new Connection(channel, this.config.readHandler, new WriteHandler());
        Object client = this.config.clientFactory.create(connection);
        ((Client)client).setResourcePool(ResourcePool.initialize(this.config));
        connection.setClient(client);
        connection.read();
        ((Client)client).onConnected();
        return client;
    }
}

