/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ReadHandler;
import io.github.joealisson.mmocore.WriteHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection<T extends Client<Connection<T>>> {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private final AsynchronousSocketChannel channel;
    private final ReadHandler<T> readHandler;
    private final WriteHandler<T> writeHandler;
    private T client;
    private ByteBuffer readingBuffer;
    private ByteBuffer writingBuffer;

    Connection(AsynchronousSocketChannel channel, ReadHandler<T> readHandler, WriteHandler<T> writeHandler) {
        this.channel = channel;
        this.readHandler = readHandler;
        this.writeHandler = writeHandler;
    }

    void setClient(T client) {
        this.client = client;
    }

    final void read() {
        if (this.channel.isOpen()) {
            this.channel.read(this.getReadingBuffer(), this.client, this.readHandler);
        }
    }

    final void write(ByteBuffer buffer, boolean sync) throws ExecutionException, InterruptedException {
        if (!this.channel.isOpen()) {
            return;
        }
        ByteBuffer directBuffer = this.getDirectWritingBuffer(buffer.limit());
        directBuffer.put(buffer);
        directBuffer.flip();
        if (sync) {
            this.writeSync();
        } else {
            this.write();
        }
    }

    final void write() {
        if (this.channel.isOpen() && Objects.nonNull(this.writingBuffer)) {
            this.channel.write(this.writingBuffer, this.client, this.writeHandler);
        }
    }

    private void writeSync() throws ExecutionException, InterruptedException {
        int dataSize = ((Client)this.client).getDataSentSize();
        int dataSent = 0;
        while ((dataSent += this.channel.write(this.writingBuffer).get().intValue()) < dataSize) {
        }
    }

    ByteBuffer getReadingBuffer() {
        if (Objects.isNull(this.readingBuffer)) {
            this.readingBuffer = ((Client)this.client).getResourcePool().getPooledDirectBuffer();
        }
        return this.readingBuffer;
    }

    private ByteBuffer getDirectWritingBuffer(int length) {
        if (Objects.isNull(this.writingBuffer)) {
            this.writingBuffer = ((Client)this.client).getResourcePool().getPooledDirectBuffer(length);
        }
        return this.writingBuffer;
    }

    private void releaseReadingBuffer() {
        ((Client)this.client).getResourcePool().recycleBuffer(this.readingBuffer);
        this.readingBuffer = null;
    }

    void releaseWritingBuffer() {
        ((Client)this.client).getResourcePool().recycleBuffer(this.writingBuffer);
        this.writingBuffer = null;
    }

    void close() {
        this.releaseReadingBuffer();
        this.releaseWritingBuffer();
        try {
            this.channel.close();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    String getRemoteAddress() {
        try {
            InetSocketAddress address = (InetSocketAddress)this.channel.getRemoteAddress();
            return address.getAddress().getHostAddress();
        }
        catch (IOException e) {
            return "";
        }
    }

    boolean isOpen() {
        try {
            return this.channel.isOpen() && Objects.nonNull(this.channel.getRemoteAddress());
        }
        catch (Exception e) {
            return false;
        }
    }
}

