/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.WritablePacket;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client<T extends Connection<?>> {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    static final int HEADER_SIZE = 2;
    private final T connection;
    private Queue<WritablePacket<? extends Client<T>>> packetsToWrite = new ConcurrentLinkedQueue<WritablePacket<? extends Client<T>>>();
    private int dataSentSize;
    private AtomicBoolean writing = new AtomicBoolean(false);
    private volatile boolean isClosing;
    private ResourcePool resourcePool;
    private ByteBuffer buffer;

    public Client(T connection) {
        if (Objects.isNull(connection) || !((Connection)connection).isOpen()) {
            throw new IllegalArgumentException("The Connection is null or closed");
        }
        this.connection = connection;
    }

    T getConnection() {
        return this.connection;
    }

    protected void writePacket(WritablePacket<? extends Client<T>> packet) {
        if (!this.isConnected() || Objects.isNull(packet)) {
            return;
        }
        this.packetsToWrite.add(packet);
        this.tryWriteNextPacket();
    }

    private void tryWriteNextPacket() {
        logger.debug("Trying to send next packet");
        if (this.writing.compareAndSet(false, true)) {
            if (this.packetsToWrite.isEmpty()) {
                this.writing.getAndSet(false);
                logger.debug("no packet found");
            } else {
                this.write(this.packetsToWrite.poll());
            }
        }
    }

    private void write(WritablePacket<? extends Client<T>> packet) {
        try {
            this.write(packet, false);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            this.finishWriting();
        }
    }

    private void write(WritablePacket packet, boolean sync) throws ExecutionException, InterruptedException {
        this.getBuffer(packet.size(this)).position(2);
        int dataSize = packet.writeData(this, this.buffer);
        if (dataSize <= 0) {
            this.finishWriting();
            return;
        }
        this.dataSentSize = this.encrypt(this.buffer.array(), 2, dataSize - 2) + 2;
        if (this.dataSentSize > 2) {
            this.buffer.putShort(0, (short)this.dataSentSize).position(this.dataSentSize);
            this.buffer.flip();
            ((Connection)this.connection).write(this.buffer, sync);
            logger.debug("Sending packet {} to {}", (Object)packet.toString(), (Object)this);
        } else {
            this.finishWriting();
        }
    }

    private ByteBuffer getBuffer(int size) {
        if (Objects.isNull(this.buffer)) {
            this.buffer = size > 2 ? this.resourcePool.getPooledBuffer(size) : this.resourcePool.getPooledBuffer();
        }
        return this.buffer;
    }

    public void close(WritablePacket<? extends Client<T>> packet) {
        if (!this.isConnected()) {
            return;
        }
        this.isClosing = true;
        logger.debug("Closing client connection {} with packet {}", (Object)this, packet);
        this.packetsToWrite.clear();
        if (Objects.nonNull(packet)) {
            try {
                this.ensureCanWrite();
                this.write(packet, true);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.warn(e.getLocalizedMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.disconnect();
    }

    void resumeSend(int result) {
        this.dataSentSize -= result;
        ((Connection)this.connection).write();
    }

    void finishWriting() {
        ((Connection)this.connection).releaseWritingBuffer();
        this.resourcePool.recycleBuffer(this.buffer);
        this.buffer = null;
        this.writing.getAndSet(false);
        this.tryWriteNextPacket();
    }

    private synchronized void ensureCanWrite() throws InterruptedException {
        while (!this.writing.compareAndSet(false, true)) {
            this.wait(500L);
        }
    }

    protected final void disconnect() {
        logger.debug("Client {} disconnecting", (Object)this);
        this.onDisconnection();
        ((Connection)this.connection).close();
    }

    int getDataSentSize() {
        return this.dataSentSize;
    }

    public String getHostAddress() {
        return ((Connection)this.connection).getRemoteAddress();
    }

    public boolean isConnected() {
        return ((Connection)this.connection).isOpen() && !this.isClosing;
    }

    void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public abstract int encrypt(byte[] var1, int var2, int var3);

    public abstract boolean decrypt(byte[] var1, int var2, int var3);

    protected abstract void onDisconnection();

    public abstract void onConnected();
}

