/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.AbstractPacket;
import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.StaticPacket;
import java.util.Arrays;
import java.util.Objects;

public abstract class WritablePacket<T extends Client<Connection<T>>>
extends AbstractPacket<T> {
    private byte[] staticData;

    protected WritablePacket() {
    }

    protected final void writeByte(byte value) {
        try {
            this.data[this.dataIndex++] = value;
        }
        catch (IndexOutOfBoundsException e) {
            this.data = Arrays.copyOf(this.data, (int)((double)(this.data.length + 1) * 1.3));
            this.data[this.dataIndex - 1] = value;
        }
    }

    protected final void writeByte(int value) {
        this.writeByte((byte)value);
    }

    protected final void writeByte(boolean value) {
        this.writeByte((byte)(value ? 1 : 0));
    }

    protected final void writeDouble(double value) {
        long x = Double.doubleToRawLongBits(value);
        this.writeLong(x);
    }

    protected final void writeShort(int value) {
        short x = WritablePacket.convertEndian((short)value);
        this.writeShortParts((byte)x, (byte)(x >>> 8));
    }

    protected final void writeShort(boolean value) {
        this.writeShort(value ? 1 : 0);
    }

    private void writeShortParts(byte b0, byte b1) {
        this.writeByte(WritablePacket.pickByte(b0, b1));
        this.writeByte(WritablePacket.pickByte(b1, b0));
    }

    protected final void writeInt(int value) {
        int x = WritablePacket.convertEndian(value);
        this.writeIntParts((byte)x, (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24));
    }

    protected final void writeInt(boolean value) {
        this.writeInt(value ? 1 : 0);
    }

    protected final void writeFloat(float value) {
        int x = Float.floatToRawIntBits(value);
        this.writeInt(x);
    }

    private void writeIntParts(byte b0, byte b1, byte b2, byte b3) {
        this.writeByte(WritablePacket.pickByte(b0, b3));
        this.writeByte(WritablePacket.pickByte(b1, b2));
        this.writeByte(WritablePacket.pickByte(b2, b1));
        this.writeByte(WritablePacket.pickByte(b3, b0));
    }

    protected final void writeLong(long value) {
        long x = WritablePacket.convertEndian(value);
        this.writeLongParts((byte)x, (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24), (byte)(x >>> 32), (byte)(x >>> 40), (byte)(x >>> 48), (byte)(x >>> 56));
    }

    private void writeLongParts(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        this.writeByte(WritablePacket.pickByte(b0, b7));
        this.writeByte(WritablePacket.pickByte(b1, b6));
        this.writeByte(WritablePacket.pickByte(b2, b5));
        this.writeByte(WritablePacket.pickByte(b3, b4));
        this.writeByte(WritablePacket.pickByte(b4, b3));
        this.writeByte(WritablePacket.pickByte(b5, b2));
        this.writeByte(WritablePacket.pickByte(b6, b1));
        this.writeByte(WritablePacket.pickByte(b7, b0));
    }

    protected final void writeBytes(byte[] bytes) {
        System.arraycopy(bytes, 0, this.data, this.dataIndex, bytes.length);
        this.dataIndex += bytes.length;
    }

    protected final void writeChar(char value) {
        short x = (short)WritablePacket.convertEndian(value);
        this.writeShortParts((byte)x, (byte)(x >>> 8));
    }

    protected final void writeString(CharSequence text) {
        if (Objects.nonNull(text)) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                this.writeChar(text.charAt(i));
            }
        }
        this.writeChar('\u0000');
    }

    protected final void writeSizedString(CharSequence text) {
        if (Objects.nonNull(text) && text.length() > 0) {
            int len = text.length();
            this.writeShort(len);
            this.writeString(text);
            this.dataIndex -= 2;
        } else {
            this.writeShort(0);
        }
    }

    int writeData() {
        if (this.hasWritedStaticData()) {
            return this.writedStaticData();
        }
        if (this.callPacketWrite()) {
            if (this.getClass().isAnnotationPresent(StaticPacket.class)) {
                this.staticData = new byte[this.dataIndex];
                System.arraycopy(this.data, 0, this.staticData, 0, this.dataIndex);
            }
            return this.dataIndex;
        }
        return 0;
    }

    private int writedStaticData() {
        System.arraycopy(this.staticData, 0, this.data, 0, this.staticData.length);
        return this.staticData.length;
    }

    private boolean callPacketWrite() {
        this.data = new byte[Math.max(2, this.packetSize())];
        this.dataIndex += 2;
        return this.write();
    }

    private static byte pickByte(byte le, byte be) {
        return IS_BIG_ENDIAN ? be : le;
    }

    protected int packetSize() {
        return 4096;
    }

    protected abstract boolean write();

    void writeHeader(int dataSize) {
        short header = WritablePacket.convertEndian((short)dataSize);
        byte tmp = (byte)(header >>> 8);
        this.data[0] = WritablePacket.pickByte((byte)header, tmp);
        this.data[1] = WritablePacket.pickByte(tmp, (byte)header);
    }

    private boolean hasWritedStaticData() {
        return this.getClass().isAnnotationPresent(StaticPacket.class) && Objects.nonNull(this.staticData);
    }
}

