/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.ConnectionConfig;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class ResourcePool {
    static final int DEFAULT_BUFFER_SIZE = 4096;
    private final Map<Integer, Queue<ByteBuffer>> buffers = new HashMap<Integer, Queue<ByteBuffer>>();
    private final ConnectionConfig config;

    private ResourcePool(ConnectionConfig config) {
        this.config = config;
    }

    ByteBuffer getPooledBuffer() {
        return this.getSizedBuffer(this.config.bufferDefaultSize);
    }

    ByteBuffer getPooledBuffer(int size) {
        size = this.determineBufferSize(size);
        return this.getSizedBuffer(size);
    }

    private ByteBuffer getSizedBuffer(int size) {
        Queue<ByteBuffer> queue = this.queueFromSize(size);
        ByteBuffer buffer = queue.poll();
        return Objects.nonNull(buffer) ? buffer : ByteBuffer.allocateDirect(size).order(this.config.byteOrder);
    }

    private Queue<ByteBuffer> queueFromSize(int size) {
        Queue<ByteBuffer> queue = this.buffers.get(size);
        if (Objects.isNull(queue)) {
            queue = new ConcurrentLinkedQueue<ByteBuffer>();
            this.buffers.put(size, queue);
        }
        return queue;
    }

    private int determineBufferSize(int size) {
        size = size <= this.config.bufferMinSize ? this.config.bufferMinSize : (size <= this.config.bufferMediumSize ? this.config.bufferMediumSize : (size <= this.config.bufferLargeSize ? this.config.bufferLargeSize : this.config.bufferDefaultSize));
        return size;
    }

    void recycleBuffer(ByteBuffer buffer) {
        if (Objects.nonNull(buffer)) {
            int size = buffer.capacity();
            int poolSize = this.determinePoolSize(size);
            Queue<ByteBuffer> queue = this.buffers.get(buffer.capacity());
            if (Objects.nonNull(queue) && queue.size() < poolSize) {
                buffer.clear();
                queue.add(buffer);
            }
        }
    }

    private int determinePoolSize(int size) {
        int poolSize = this.config.bufferPoolSize;
        if (size == this.config.bufferMinSize) {
            poolSize = this.config.bufferMinPoolSize;
        } else if (size == this.config.bufferMediumSize) {
            poolSize = this.config.bufferMediumPoolSize;
        } else if (size == this.config.bufferLargePoolSize) {
            poolSize = this.config.bufferLargePoolSize;
        }
        return poolSize;
    }

    static ResourcePool initialize(ConnectionConfig config) {
        return new ResourcePool(config);
    }
}

