/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.AbstractPacket;
import java.nio.charset.StandardCharsets;

public abstract class ReadablePacket<T>
extends AbstractPacket<T>
implements Runnable {
    protected ReadablePacket() {
    }

    protected final int availableData() {
        return this.data.length - this.dataIndex;
    }

    protected final void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    protected final void readBytes(byte[] dst, int offset, int length) {
        System.arraycopy(this.data, this.dataIndex, dst, offset, length);
        this.dataIndex += length;
    }

    protected final byte readByte() {
        return this.data[this.dataIndex++];
    }

    protected final char readChar() {
        return ReadablePacket.convertEndian((char)this.readShort());
    }

    protected final int readUnsignedByte() {
        return Byte.toUnsignedInt(this.data[this.dataIndex++]);
    }

    protected final short readShort() {
        return ReadablePacket.convertEndian((short)(this.readUnsignedByte() << ReadablePacket.pickShift(8, 0) | this.readUnsignedByte() << ReadablePacket.pickShift(8, 8)));
    }

    protected final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    protected final int readInt() {
        return ReadablePacket.convertEndian(this.readUnsignedByte() << ReadablePacket.pickShift(24, 0) | this.readUnsignedByte() << ReadablePacket.pickShift(24, 8) | this.readUnsignedByte() << ReadablePacket.pickShift(24, 16) | this.readUnsignedByte() << ReadablePacket.pickShift(24, 24));
    }

    protected final long readLong() {
        return ReadablePacket.convertEndian(Byte.toUnsignedLong(this.readByte()) << ReadablePacket.pickShift(56, 0) | Byte.toUnsignedLong(this.readByte()) << ReadablePacket.pickShift(56, 8) | Byte.toUnsignedLong(this.readByte()) << ReadablePacket.pickShift(56, 16) | Byte.toUnsignedLong(this.readByte()) << ReadablePacket.pickShift(56, 24) | Byte.toUnsignedLong(this.readByte()) << ReadablePacket.pickShift(56, 32) | Byte.toUnsignedLong(this.readByte()) << ReadablePacket.pickShift(56, 40) | Byte.toUnsignedLong(this.readByte()) << ReadablePacket.pickShift(56, 48) | Byte.toUnsignedLong(this.readByte()) << ReadablePacket.pickShift(56, 56));
    }

    protected final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    protected final String readString() {
        int start = this.dataIndex;
        int size = 0;
        while (this.dataIndex < this.data.length && this.readChar() != '\u0000') {
            size += 2;
        }
        return new String(this.data, start, size, StandardCharsets.UTF_16LE);
    }

    protected final String readSizedString() {
        int size = this.readShort() * 2;
        String result = new String(this.data, this.dataIndex, size, StandardCharsets.UTF_16LE);
        this.dataIndex += size;
        return result;
    }

    private static int pickShift(int top, int pos) {
        return IS_BIG_ENDIAN ? top - pos : pos;
    }

    protected abstract boolean read();
}

