/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionConfig;
import io.github.joealisson.mmocore.ResourcePool;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionHandler<T extends Client<Connection<T>>>
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionHandler.class);
    private final AsynchronousChannelGroup group;
    private final AsynchronousServerSocketChannel listener;
    private final ConnectionConfig<T> config;
    private volatile boolean shutdown;
    private boolean cached;
    private final ResourcePool resourcePool;

    ConnectionHandler(ConnectionConfig<T> config) throws IOException {
        this.config = config;
        this.resourcePool = ResourcePool.initialize(config);
        this.group = this.createChannelGroup(config.threadPoolSize);
        this.listener = this.group.provider().openAsynchronousServerSocketChannel(this.group);
        this.listener.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.listener.bind(config.address);
    }

    private AsynchronousChannelGroup createChannelGroup(int threadPoolSize) throws IOException {
        if (threadPoolSize <= 0 || threadPoolSize >= Short.MAX_VALUE) {
            this.cached = true;
            logger.debug("Channel group is using CachedThreadPool");
            return AsynchronousChannelGroup.withCachedThreadPool(Executors.newCachedThreadPool(), Runtime.getRuntime().availableProcessors());
        }
        logger.debug("Channel group is using FixedThreadPool");
        return AsynchronousChannelGroup.withFixedThreadPool(threadPoolSize, Executors.defaultThreadFactory());
    }

    @Override
    public void run() {
        this.listener.accept(null, new AcceptConnectionHandler());
        if (this.cached) {
            while (!this.shutdown) {
                try {
                    Thread.sleep(this.config.shutdownWaitTime);
                }
                catch (InterruptedException e) {
                    logger.warn(e.getLocalizedMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void closeConnection() {
        try {
            this.listener.close();
            this.group.awaitTermination(this.config.shutdownWaitTime, TimeUnit.MILLISECONDS);
            this.group.shutdownNow();
        }
        catch (Exception e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        logger.debug("Shutting ConnectionHandler down");
        this.shutdown = true;
        this.closeConnection();
    }

    private class AcceptConnectionHandler
    implements CompletionHandler<AsynchronousSocketChannel, Void> {
        private AcceptConnectionHandler() {
        }

        @Override
        public void completed(AsynchronousSocketChannel clientChannel, Void attachment) {
            if (!ConnectionHandler.this.shutdown && ConnectionHandler.this.listener.isOpen()) {
                ConnectionHandler.this.listener.accept(null, this);
            }
            this.acceptConnection(clientChannel);
        }

        @Override
        public void failed(Throwable t, Void attachment) {
            logger.error(t.getLocalizedMessage(), t);
        }

        private void acceptConnection(AsynchronousSocketChannel channel) {
            if (Objects.nonNull(channel) && channel.isOpen()) {
                try {
                    logger.debug("Accepting connection from {}", (Object)channel);
                    if (Objects.nonNull(((ConnectionHandler)ConnectionHandler.this).config.acceptFilter) && !((ConnectionHandler)ConnectionHandler.this).config.acceptFilter.accept(channel)) {
                        channel.close();
                        logger.debug("Rejected connection");
                        return;
                    }
                    channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)(!((ConnectionHandler)ConnectionHandler.this).config.useNagle ? 1 : 0));
                    Connection connection = new Connection(channel, ((ConnectionHandler)ConnectionHandler.this).config.readHandler, ((ConnectionHandler)ConnectionHandler.this).config.writeHandler);
                    Object client = ((ConnectionHandler)ConnectionHandler.this).config.clientFactory.create(connection);
                    ((Client)client).setResourcePool(ConnectionHandler.this.resourcePool);
                    connection.setClient(client);
                    ((Client)client).onConnected();
                    connection.read();
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

