/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ClientFactory;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionConfig;
import io.github.joealisson.mmocore.ConnectionFilter;
import io.github.joealisson.mmocore.ConnectionHandler;
import io.github.joealisson.mmocore.PacketExecutor;
import io.github.joealisson.mmocore.PacketHandler;
import io.github.joealisson.mmocore.ReadHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;

public class ConnectionBuilder<T extends Client<Connection<T>>> {
    private ConnectionConfig<T> config;

    public static <T extends Client<Connection<T>>> ConnectionBuilder<T> create(InetSocketAddress address, ClientFactory<T> clientFactory, PacketHandler<T> packetHandler, PacketExecutor<T> executor) {
        ConnectionBuilder<T> builder = new ConnectionBuilder<T>();
        builder.config = new ConnectionConfig<T>(address, clientFactory, new ReadHandler<T>(packetHandler, executor));
        return builder;
    }

    public ConnectionBuilder<T> filter(ConnectionFilter filter) {
        this.config.acceptFilter = filter;
        return this;
    }

    public ConnectionBuilder<T> threadPoolSize(int size) {
        this.config.threadPoolSize = size;
        return this;
    }

    public ConnectionBuilder<T> useNagle(boolean useNagle) {
        this.config.useNagle = useNagle;
        return this;
    }

    public ConnectionBuilder<T> shutdownWaitTime(long waitTime) {
        this.config.shutdownWaitTime = waitTime;
        return this;
    }

    public ConnectionBuilder<T> bufferDefaultSize(int bufferSize) {
        this.config.bufferDefaultSize = Math.min(bufferSize, 65536);
        return this;
    }

    public ConnectionBuilder<T> bufferMinSize(int bufferSize) {
        this.config.bufferMinSize = Math.min(bufferSize, 65536);
        return this;
    }

    public ConnectionBuilder<T> bufferLargeSize(int bufferSize) {
        this.config.bufferLargeSize = Math.min(bufferSize, 65536);
        return this;
    }

    public ConnectionBuilder<T> bufferMediumSize(int bufferSize) {
        this.config.bufferMediumSize = Math.min(bufferSize, 65536);
        return this;
    }

    public ConnectionBuilder<T> bufferPoolSize(int bufferPoolSize) {
        this.config.bufferPoolSize = bufferPoolSize;
        return this;
    }

    public ConnectionBuilder<T> bufferMinPoolSize(int bufferPoolSize) {
        this.config.bufferMinPoolSize = bufferPoolSize;
        return this;
    }

    public ConnectionBuilder<T> bufferMediumPoolSize(int bufferPoolSize) {
        this.config.bufferMediumPoolSize = bufferPoolSize;
        return this;
    }

    public ConnectionBuilder<T> bufferLargePoolSize(int bufferPoolSize) {
        this.config.bufferLargePoolSize = bufferPoolSize;
        return this;
    }

    public ConnectionBuilder<T> byteOrder(ByteOrder order) {
        this.config.byteOrder = order;
        return this;
    }

    public ConnectionHandler<T> build() throws IOException {
        return new ConnectionHandler<T>(this.config);
    }
}

