/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ReadHandler;
import io.github.joealisson.mmocore.WriteHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection<T extends Client<Connection<T>>> {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private final AsynchronousSocketChannel channel;
    private final ReadHandler<T> readHandler;
    private final WriteHandler<T> writeHandler;
    private T client;
    private ByteBuffer readingBuffer;
    private ByteBuffer writingBuffer;

    Connection(AsynchronousSocketChannel channel, ReadHandler<T> readHandler, WriteHandler<T> writeHandler) {
        this.channel = channel;
        this.readHandler = readHandler;
        this.writeHandler = writeHandler;
    }

    void setClient(T client) {
        this.client = client;
    }

    final void read() {
        if (this.channel.isOpen()) {
            this.channel.read(this.getReadingBuffer(), this.client, this.readHandler);
        }
    }

    final void write(byte[] data, int offset, int length, boolean sync) {
        if (!this.channel.isOpen()) {
            return;
        }
        ByteBuffer buffer = this.getWritingBuffer(length);
        buffer.put(data, offset, length);
        buffer.flip();
        if (sync) {
            this.writeSync();
        } else {
            this.write();
        }
    }

    final void write() {
        if (this.channel.isOpen() && Objects.nonNull(this.writingBuffer)) {
            this.channel.write(this.writingBuffer, this.client, this.writeHandler);
        }
    }

    private void writeSync() {
        try {
            int dataSize = ((Client)this.client).getDataSentSize();
            int dataSent = 0;
            while ((dataSent += this.channel.write(this.writingBuffer).get().intValue()) < dataSize) {
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    ByteBuffer getReadingBuffer() {
        if (Objects.isNull(this.readingBuffer)) {
            this.readingBuffer = ((Client)this.client).getResourcePool().getPooledBuffer();
        }
        return this.readingBuffer;
    }

    private ByteBuffer getWritingBuffer(int length) {
        if (Objects.isNull(this.writingBuffer)) {
            this.writingBuffer = ((Client)this.client).getResourcePool().getPooledBuffer(length);
        }
        return this.writingBuffer;
    }

    private void releaseReadingBuffer() {
        ((Client)this.client).getResourcePool().recycleBuffer(this.readingBuffer);
        this.readingBuffer = null;
    }

    void releaseWritingBuffer() {
        ((Client)this.client).getResourcePool().recycleBuffer(this.writingBuffer);
        this.writingBuffer = null;
    }

    void close() {
        this.releaseReadingBuffer();
        this.releaseWritingBuffer();
        try {
            this.channel.close();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    String getRemoteAddress() {
        try {
            InetSocketAddress address = (InetSocketAddress)this.channel.getRemoteAddress();
            return address.getAddress().getHostAddress();
        }
        catch (IOException e) {
            return "";
        }
    }

    boolean isOpen() {
        try {
            return this.channel.isOpen() && Objects.nonNull(this.channel.getRemoteAddress());
        }
        catch (Exception e) {
            return false;
        }
    }
}

