/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ResourcePool;
import io.github.joealisson.mmocore.WritablePacket;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client<T extends Connection<?>> {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private final T connection;
    private Queue<WritablePacket<? extends Client<T>>> packetsToWrite = new ConcurrentLinkedQueue<WritablePacket<? extends Client<T>>>();
    private int dataSentSize;
    private AtomicBoolean writing = new AtomicBoolean(false);
    private volatile boolean isClosing;
    private ResourcePool resourcePool;

    public Client(T connection) {
        if (Objects.isNull(connection) || !((Connection)connection).isOpen()) {
            throw new IllegalArgumentException("The Connection is null or closed");
        }
        this.connection = connection;
    }

    T getConnection() {
        return this.connection;
    }

    protected void writePacket(WritablePacket<? extends Client<T>> packet) {
        if (!this.isConnected() || Objects.isNull(packet)) {
            return;
        }
        this.putClientOnPacket(packet);
        this.packetsToWrite.add(packet);
        this.tryWriteNextPacket();
    }

    private void putClientOnPacket(WritablePacket packet) {
        packet.client = this;
    }

    private void tryWriteNextPacket() {
        logger.debug("Trying to send next packet");
        if (this.writing.compareAndSet(false, true)) {
            if (this.packetsToWrite.isEmpty()) {
                this.writing.getAndSet(false);
                logger.debug("no packet found");
            } else {
                WritablePacket<? extends Client<T>> packet = this.packetsToWrite.poll();
                this.write(packet);
            }
        }
    }

    void resumeSend(int result) {
        this.dataSentSize -= result;
        ((Connection)this.connection).write();
    }

    void finishWriting() {
        ((Connection)this.connection).releaseWritingBuffer();
        this.writing.getAndSet(false);
        this.tryWriteNextPacket();
    }

    private void write(WritablePacket packet, boolean sync) {
        if (Objects.isNull(packet)) {
            return;
        }
        int dataSize = packet.writeData();
        if (dataSize <= 0) {
            return;
        }
        this.dataSentSize = this.encrypt(packet.data, 2, dataSize - 2) + 2;
        if (this.dataSentSize > 0) {
            packet.writeHeader(this.dataSentSize);
            ((Connection)this.connection).write(packet.data, 0, this.dataSentSize, sync);
            logger.debug("Sending packet {} to {}", (Object)packet, (Object)this);
        }
    }

    private void write(WritablePacket<? extends Client<T>> packet) {
        try {
            this.write(packet, false);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            this.writing.getAndSet(false);
            this.tryWriteNextPacket();
        }
    }

    public void close(WritablePacket<? extends Client<T>> packet) {
        if (!this.isConnected()) {
            return;
        }
        this.isClosing = true;
        logger.debug("Closing client connection {} with packet {}", (Object)this, packet);
        this.packetsToWrite.clear();
        if (Objects.nonNull(packet)) {
            this.putClientOnPacket(packet);
            this.ensureCanWrite();
            this.write(packet, true);
        }
        this.disconnect();
    }

    private synchronized void ensureCanWrite() {
        while (!this.writing.compareAndSet(false, true)) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                logger.warn(e.getLocalizedMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    protected final void disconnect() {
        logger.debug("Client {} disconnecting", (Object)this);
        this.onDisconnection();
        ((Connection)this.connection).close();
    }

    int getDataSentSize() {
        return this.dataSentSize;
    }

    public String getHostAddress() {
        return ((Connection)this.connection).getRemoteAddress();
    }

    protected boolean isConnected() {
        return ((Connection)this.connection).isOpen() && !this.isClosing;
    }

    void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public abstract int encrypt(byte[] var1, int var2, int var3);

    public abstract boolean decrypt(byte[] var1, int var2, int var3);

    protected abstract void onDisconnection();

    public abstract void onConnected();
}

