/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.Connection;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteHandler<T extends Client<Connection<T>>>
implements CompletionHandler<Integer, T> {
    private static final Logger logger = LoggerFactory.getLogger(WriteHandler.class);

    WriteHandler() {
    }

    @Override
    public void completed(Integer result, T client) {
        if (result < 0) {
            logger.warn("Couldn't send data to client {}", client);
            if (((Client)client).isConnected()) {
                ((Client)client).disconnect();
            }
            return;
        }
        if (result < ((Client)client).getDataSentSize()) {
            logger.debug("Still data to send. Trying to send");
            ((Client)client).resumeSend(result);
        } else {
            ((Client)client).finishWriting();
        }
    }

    @Override
    public void failed(Throwable e, T client) {
        if (((Client)client).isConnected()) {
            ((Client)client).disconnect();
        }
        if (!(e instanceof AsynchronousCloseException)) {
            logger.error(e.getLocalizedMessage(), e);
        }
    }
}

