/*
 * Decompiled with CFR 0.152.
 */
package io.github.joealisson.mmocore;

import io.github.joealisson.mmocore.Client;
import io.github.joealisson.mmocore.ClientFactory;
import io.github.joealisson.mmocore.Connection;
import io.github.joealisson.mmocore.ConnectionFilter;
import io.github.joealisson.mmocore.ReadHandler;
import io.github.joealisson.mmocore.WriteHandler;
import java.net.SocketAddress;
import java.nio.ByteOrder;

class ConnectionConfig<T extends Client<Connection<T>>> {
    static final int BUFFER_MAX_SIZE = 65536;
    int bufferDefaultSize = 9216;
    int bufferMinSize = 4096;
    int bufferMediumSize = 1024;
    int bufferLargeSize = 64;
    int bufferPoolSize = 100;
    int bufferMinPoolSize = 100;
    int bufferMediumPoolSize = 50;
    int bufferLargePoolSize = 10;
    long shutdownWaitTime = 5000L;
    ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    boolean useNagle;
    ClientFactory<T> clientFactory;
    ConnectionFilter acceptFilter;
    ReadHandler<T> readHandler;
    WriteHandler<T> writeHandler;
    int threadPoolSize;
    SocketAddress address;

    ConnectionConfig(SocketAddress address, ClientFactory<T> factory, ReadHandler<T> readHandler) {
        this.address = address;
        this.clientFactory = factory;
        this.readHandler = readHandler;
        this.writeHandler = new WriteHandler();
        this.threadPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
    }
}

