/*
 * Decompiled with CFR 0.152.
 */
package io.github.jmusacchio.kogito.generator.gradle.plugin.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.util.maven.support.ReleaseIdImpl;

public final class Util {
    public static List<URL> getProjectFiles(Project project, List<InternalKieModule> kmoduleDeps) throws IOException {
        List<URL> urls = Util.classpathUrls(project);
        List<File> artifacts = Util.mainBuilds(project.getBuildDir(), file -> file);
        for (File artifact : artifacts) {
            if (!artifact.getName().endsWith(".jar")) continue;
            Util.populateURLsFromJarArtifact(project, artifact, kmoduleDeps);
        }
        return urls;
    }

    public static ClassLoader createProjectClassLoader(ClassLoader parentClassLoader, Project project, File outputDirectory, List<InternalKieModule> kmoduleDeps) {
        try {
            List<URL> urls = Util.getProjectFiles(project, kmoduleDeps);
            urls.add(outputDirectory.toURI().toURL());
            return URLClassLoader.newInstance(urls.toArray(new URL[0]), parentClassLoader);
        }
        catch (IOException var5) {
            throw new RuntimeException("Error setting up Kie ClassLoader", var5);
        }
    }

    public static SourceDirectorySet projectSourceDirectory(Project project) {
        SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getProperties().get("sourceSets");
        return ((SourceSet)sourceSetContainer.getByName("main")).getAllJava();
    }

    private static void populateURLsFromJarArtifact(Project project, File file, List<InternalKieModule> kmoduleDeps) throws IOException {
        if (file != null && file.isFile()) {
            KieModuleModel depModel = Util.getDependencyKieModel(file);
            if (kmoduleDeps != null && depModel != null) {
                ReleaseIdImpl releaseId = new ReleaseIdImpl(project.getGroup().toString(), project.getName(), project.getVersion().toString());
                kmoduleDeps.add((InternalKieModule)new ZipKieModule((ReleaseId)releaseId, depModel, file));
            }
        }
    }

    private static KieModuleModel getDependencyKieModel(File jar) throws IOException {
        try (ZipFile zipFile = new ZipFile(jar);){
            ZipEntry zipEntry = zipFile.getEntry(KieModuleModelImpl.KMODULE_JAR_PATH.asString());
            if (zipEntry != null) {
                KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
                KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
                KieModuleModel kieModuleModel2 = kieModuleModel;
                return kieModuleModel2;
            }
        }
        return null;
    }

    public static List<File> classpathFiles(Project project) {
        return Util.classpath(project, file -> file);
    }

    public static List<URL> classpathUrls(Project project) {
        return Util.classpath(project, file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static <T> List<T> classpath(Project project, Function<File, T> fn) {
        return Stream.concat(Stream.concat(Util.mainBuilds(project.getBuildDir(), fn).stream(), project.getRootProject().getSubprojects().stream().flatMap(s -> Util.mainBuilds(s.getBuildDir(), fn).stream())), project.getConfigurations().getByName("compileClasspath").getFiles().stream().filter(f -> !f.getName().endsWith(".pom")).map(f -> fn.apply((File)f))).collect(Collectors.toList());
    }

    private static <T> List<T> mainBuilds(File buildDir, Function<File, T> fn) {
        if (buildDir.getName().equals("main")) {
            return InvokerHelper.asList(fn.apply(buildDir));
        }
        if (buildDir.listFiles() != null) {
            return Arrays.stream(buildDir.listFiles()).flatMap(d -> Util.mainBuilds(d, fn).stream()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Util() {
    }
}

