/*
 * Decompiled with CFR 0.152.
 */
package io.github.jmusacchio.kogito.generator.gradle.plugin.tasks;

import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.KogitoExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.ProcessClassesExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.tasks.AbstractKieTask;
import io.github.jmusacchio.kogito.generator.gradle.plugin.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.util.PortablePath;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.kie.kogito.Model;
import org.kie.kogito.ProcessInput;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.utils.GeneratedFileValidation;
import org.kie.kogito.codegen.json.JsonSchemaGenerator;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.ReflectionMarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;

@CacheableTask
public class ProcessClassesTask
extends AbstractKieTask {
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.loadCompiler((JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE, (String)"1.8");
    @Optional
    @Input
    private String schemaVersion;

    @Inject
    public ProcessClassesTask(KogitoExtension extension, ProcessClassesExtension processClassesExtension, AbstractCompile compile) {
        super(extension);
        this.schemaVersion = processClassesExtension.getSchemaVersion();
        this.setOutputDirectory(compile.getDestinationDir());
    }

    @TaskAction
    public void execute() {
        try {
            JavaCompilerSettings settings = new JavaCompilerSettings();
            Util.classpathFiles(this.getProject()).stream().forEach(file -> settings.addClasspath(file));
            Set modelClasses = this.getReflections().getSubTypesOf(Model.class);
            ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build((Collection)modelClasses);
            ClassLoader classLoader = this.projectClassLoader();
            KogitoBuildContext context = this.discoverKogitoRuntimeContext(classLoader);
            PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator, (MarshallerGenerator)new ReflectionMarshallerGenerator(context, protoGenerator.getDataClasses()));
            Collection persistenceFiles = persistenceGenerator.generate();
            GeneratedFileValidation.validateGeneratedFileTypes((Collection)persistenceFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.INTERNAL_RESOURCE, GeneratedFileType.Category.STATIC_HTTP_RESOURCE));
            Collection generatedClasses = persistenceFiles.stream().filter(x -> x.category().equals((Object)GeneratedFileType.Category.SOURCE)).collect(Collectors.toList());
            Collection generatedResources = persistenceFiles.stream().filter(x -> x.category().equals((Object)GeneratedFileType.Category.INTERNAL_RESOURCE) || x.category().equals((Object)GeneratedFileType.Category.STATIC_HTTP_RESOURCE)).collect(Collectors.toList());
            this.compileAndWriteClasses(generatedClasses, classLoader, settings);
            generatedResources.forEach(this::writeGeneratedFile);
            Stream<Class<?>> processClassStream = this.getReflections().getTypesAnnotatedWith(ProcessInput.class).stream();
            this.generateJsonSchema(processClassStream).forEach(this::writeGeneratedFile);
            Stream<Class<?>> userTaskClassStream = this.getReflections().getTypesAnnotatedWith(UserTask.class).stream();
            this.generateJsonSchema(userTaskClassStream).forEach(this::writeGeneratedFile);
        }
        catch (Exception var12) {
            throw new RuntimeException("Error during processing model classes", var12);
        }
    }

    private void compileAndWriteClasses(Collection<GeneratedFile> generatedClasses, ClassLoader cl, JavaCompilerSettings settings) {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        String[] sources = new String[generatedClasses.size()];
        int index = 0;
        for (GeneratedFile entry : generatedClasses) {
            String fileName = entry.relativePath();
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.contents());
        }
        if (sources.length > 0) {
            CompilationResult result = JAVA_COMPILER.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, cl, settings);
            if (result.getErrors().length > 0) {
                throw new RuntimeException(Arrays.toString(result.getErrors()));
            }
            for (PortablePath path : trgMfs.getFilePaths()) {
                byte[] data = trgMfs.getBytes(path);
                this.writeGeneratedFile(new GeneratedFile(GeneratedFileType.COMPILED_CLASS, path.asString(), data));
            }
        }
    }

    private Collection<GeneratedFile> generateJsonSchema(Stream<Class<?>> classes) throws IOException {
        return new JsonSchemaGenerator.ClassBuilder(classes).withSchemaVersion(this.getSchemaVersion()).build().generate();
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }
}

