/*
 * Decompiled with CFR 0.152.
 */
package io.github.jmusacchio.kogito.generator.gradle.plugin.tasks;

import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.KogitoExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.util.Util;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;

@CacheableTask
public class KogitoCompileTask
extends JavaCompile {
    @Optional
    @InputFiles
    @CompileClasspath
    private File generatedSources;
    @Optional
    @InputFiles
    @CompileClasspath
    private File generatedResources;

    @Inject
    public KogitoCompileTask(KogitoExtension extension, AbstractCompile compile) {
        this.generatedSources = extension.getGeneratedSources();
        this.generatedResources = extension.getGeneratedResources();
        this.source(new Object[]{this.getGeneratedSources(), this.getGeneratedResources(), Util.projectSourceDirectory(this.getProject()).getSrcDirs().stream().findFirst().orElse(this.getGeneratedSources())});
        this.setClasspath(compile.getClasspath());
        this.setDestinationDir(compile.getDestinationDir());
    }

    public FileCollection getClasspath() {
        return ((FileCollectionFactory)this.getServices().get(FileCollectionFactory.class)).fixed(Util.classpathFiles(this.getProject()));
    }

    public File getGeneratedSources() {
        return this.generatedSources;
    }

    public File getGeneratedResources() {
        return this.generatedResources;
    }
}

