/*
 * Decompiled with CFR 0.152.
 */
package io.github.jmusacchio.kogito.generator.gradle.plugin.tasks;

import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.GenerateModelExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.KogitoExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.tasks.AbstractKieTask;
import io.github.jmusacchio.kogito.generator.gradle.plugin.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.ApplicationGenerator;
import org.kie.kogito.codegen.core.utils.ApplicationGeneratorDiscovery;

@CacheableTask
public class GenerateModelTask
extends AbstractKieTask {
    public static final PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Optional
    @InputFiles
    @CompileClasspath
    private File customizableSourcesPath;
    @Optional
    @Input
    private Boolean generatePartial;
    @Optional
    @Input
    private Boolean onDemand;
    @Optional
    @Input
    private Boolean keepSources;
    @Optional
    @Input
    private String buildOutputDirectory;

    @Inject
    public GenerateModelTask(KogitoExtension extension, GenerateModelExtension modelExtension) {
        super(extension);
        this.customizableSourcesPath = modelExtension.getCustomizableSourcesPath();
        this.generatePartial = modelExtension.isGeneratePartial();
        this.onDemand = modelExtension.isOnDemand();
        this.keepSources = modelExtension.isKeepSources();
        this.buildOutputDirectory = modelExtension.getBuildOutputDirectory();
    }

    @TaskAction
    public void execute() {
        boolean indexFileDirectorySet = false;
        this.getLogger().debug("execute -> " + this.getBuildOutputDirectory());
        if (this.getBuildOutputDirectory() == null) {
            throw new RuntimeException("${project.buildDir} is null");
        }
        if (System.getProperty("indexfile.directory") == null) {
            System.setProperty("indexfile.directory", this.getBuildOutputDirectory());
            indexFileDirectorySet = true;
        }
        this.addCompileSourceRoots();
        if (this.getOnDemand().booleanValue()) {
            this.getLogger().info("On-Demand Mode is On. Use gradle build :scaffold");
        } else {
            this.generateModel();
        }
        if (indexFileDirectorySet) {
            System.clearProperty("indexfile.directory");
        }
    }

    protected void addCompileSourceRoots() {
        Util.projectSourceDirectory(this.getProject()).srcDirs(new Object[]{this.getCustomizableSourcesPath().getPath(), this.getGeneratedSources().getPath()});
    }

    protected void generateModel() {
        this.setSystemProperties(this.getProperties());
        ApplicationGenerator appGen = ApplicationGeneratorDiscovery.discover((KogitoBuildContext)this.discoverKogitoRuntimeContext(this.projectClassLoader()));
        Collection generatedFiles = this.getGeneratePartial() != false ? appGen.generateComponents() : appGen.generate();
        Map<GeneratedFileType, List<GeneratedFile>> mappedGeneratedFiles = generatedFiles.stream().collect(Collectors.groupingBy(GeneratedFile::type));
        mappedGeneratedFiles.entrySet().stream().filter(entry -> !((GeneratedFileType)entry.getKey()).equals(GeneratedFileType.COMPILED_CLASS)).forEach(entry -> this.writeGeneratedFiles((Collection)entry.getValue()));
        List<GeneratedFile> generatedCompiledFiles = mappedGeneratedFiles.getOrDefault(GeneratedFileType.COMPILED_CLASS, Collections.emptyList()).stream().map(originalGeneratedFile -> new GeneratedFile(GeneratedFileType.COMPILED_CLASS, this.convertPath(originalGeneratedFile.path().toString()), originalGeneratedFile.contents())).collect(Collectors.toList());
        this.writeGeneratedFiles(generatedCompiledFiles);
        if (!this.getKeepSources().booleanValue()) {
            this.deleteDrlFiles();
        }
    }

    private String convertPath(String toConvert) {
        return toConvert.replace('.', File.separatorChar) + ".class";
    }

    private void deleteDrlFiles() {
        try (Stream<Path> drlFiles = Files.find(this.getOutputDirectory().toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);){
            drlFiles.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find .drl files");
        }
    }

    public File getCustomizableSourcesPath() {
        return this.customizableSourcesPath;
    }

    public Boolean getGeneratePartial() {
        return this.generatePartial;
    }

    public Boolean getOnDemand() {
        return this.onDemand;
    }

    public void setOnDemand(Boolean onDemand) {
        this.onDemand = onDemand;
    }

    public Boolean getKeepSources() {
        return this.keepSources;
    }

    public String getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }
}

