/*
 * Decompiled with CFR 0.152.
 */
package io.github.jmusacchio.kogito.generator.gradle.plugin.tasks;

import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.KogitoExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.util.Util;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.GeneratedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.core.utils.GeneratedFileWriter;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public abstract class AbstractKieTask
extends DefaultTask {
    @Optional
    @Input
    private Map<String, String> properties;
    @InputFiles
    @CompileClasspath
    private File outputDirectory;
    @Optional
    @InputFiles
    @CompileClasspath
    private File generatedSources;
    @Optional
    @InputFiles
    @CompileClasspath
    private File generatedResources;
    @Optional
    @Input
    private Boolean persistence;
    @Optional
    @Input
    private Boolean generateRules;
    @Optional
    @Input
    private Boolean generateProcesses;
    @Optional
    @Input
    private Boolean generateDecisions;
    @Optional
    @Input
    private Boolean generatePredictions;
    @Internal
    private File projectDir;
    @Internal
    private Reflections reflections;

    public AbstractKieTask(KogitoExtension extension) {
        this.projectDir = extension.getProjectDir();
        this.properties = extension.getProperties();
        this.outputDirectory = extension.getOutputDirectory();
        this.generatedSources = extension.getGeneratedSources();
        this.generatedResources = extension.getGeneratedResources();
        this.persistence = extension.isPersistence();
        this.generateRules = extension.isGenerateRules();
        this.generateProcesses = extension.isGenerateProcesses();
        this.generateDecisions = extension.isGenerateDecisions();
        this.generatePredictions = extension.isGeneratePredictions();
    }

    protected void setSystemProperties(Map<String, String> properties) {
        if (properties != null) {
            this.getLogger().debug("Additional system properties: " + properties);
            for (Map.Entry<String, String> property : properties.entrySet()) {
                System.setProperty(property.getKey(), property.getValue());
            }
            this.getLogger().debug("Configured system properties were successfully set.");
        }
    }

    protected KogitoBuildContext discoverKogitoRuntimeContext(ClassLoader classLoader) {
        AppPaths appPaths = AppPaths.fromProjectDir((Path)this.getProjectDir().toPath(), (Path)this.getOutputDirectory().toPath());
        KogitoBuildContext context = this.contextBuilder().withClassAvailabilityResolver(this::hasClassOnClasspath).withClassSubTypeAvailabilityResolver(this.classSubTypeAvailabilityResolver()).withApplicationProperties(appPaths.getResourceFiles()).withPackageName(this.appPackageName()).withClassLoader(classLoader).withAppPaths(appPaths).withGAV(new KogitoGAV(this.getProject().getGroup().toString(), this.getProject().getName(), this.getProject().getVersion().toString())).build();
        this.additionalProperties(context);
        return context;
    }

    public Reflections getReflections() {
        if (this.reflections == null) {
            URLClassLoader classLoader = (URLClassLoader)this.projectClassLoader();
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.addUrls(classLoader.getURLs());
            builder.addClassLoaders(new ClassLoader[]{classLoader});
            builder.setExpandSuperTypes(false);
            this.reflections = new Reflections((Configuration)builder);
        }
        return this.reflections;
    }

    protected Predicate<Class<?>> classSubTypeAvailabilityResolver() {
        return clazz -> this.getReflections().getSubTypesOf(clazz).stream().anyMatch(c -> !c.isInterface() && !Modifier.isAbstract(c.getModifiers()));
    }

    protected ClassLoader projectClassLoader() {
        return Util.createProjectClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.getOutputDirectory(), null);
    }

    protected String appPackageName() {
        return "org.kie.kogito.app";
    }

    private void additionalProperties(KogitoBuildContext context) {
        this.classToCheckForREST().ifPresent(restClass -> {
            if (!context.hasClassAvailable(restClass)) {
                this.getLogger().info("Disabling REST generation because class '" + restClass + "' is not available");
                context.setApplicationProperty("kogito.generate.rest", "false");
            }
        });
        this.classToCheckForDI().ifPresent(diClass -> {
            if (!context.hasClassAvailable(diClass)) {
                this.getLogger().info("Disabling dependency injection generation because class '" + diClass + "' is not available");
                context.setApplicationProperty("kogito.generate.di", "false");
            }
        });
        context.setApplicationProperty("kogito.codegen.rules", this.getGenerateRules().toString());
        context.setApplicationProperty("kogito.codegen.processes", this.getGenerateProcesses().toString());
        context.setApplicationProperty("kogito.codegen.predictions", this.getGeneratePredictions().toString());
        context.setApplicationProperty("kogito.codegen.decisions", this.getGenerateDecisions().toString());
        context.setApplicationProperty("kogito.codegen.persistence", this.getPersistence().toString());
    }

    private KogitoBuildContext.Builder contextBuilder() {
        switch (this.discoverFramework()) {
            case QUARKUS: {
                return QuarkusKogitoBuildContext.builder();
            }
            case SPRING: {
                return SpringBootKogitoBuildContext.builder();
            }
        }
        return JavaKogitoBuildContext.builder();
    }

    private java.util.Optional<String> classToCheckForREST() {
        switch (this.discoverFramework()) {
            case QUARKUS: {
                return java.util.Optional.of("javax.ws.rs.Path");
            }
            case SPRING: {
                return java.util.Optional.of("org.springframework.web.bind.annotation.RestController");
            }
        }
        return java.util.Optional.empty();
    }

    private java.util.Optional<String> classToCheckForDI() {
        switch (this.discoverFramework()) {
            case QUARKUS: {
                return java.util.Optional.of("javax.inject.Inject");
            }
            case SPRING: {
                return java.util.Optional.of("org.springframework.beans.factory.annotation.Autowired");
            }
        }
        return java.util.Optional.empty();
    }

    private Framework discoverFramework() {
        if (this.hasDependency("quarkus")) {
            return Framework.QUARKUS;
        }
        return this.hasDependency("spring") ? Framework.SPRING : Framework.NONE;
    }

    private boolean hasDependency(String dependency) {
        return this.getProject().getConfigurations().stream().anyMatch(c -> c.getAllDependencies().stream().anyMatch(d -> d.getName().contains(dependency)));
    }

    private boolean hasClassOnClasspath(String className) {
        try {
            URL[] urls = (URL[])Util.classpathUrls(this.getProject()).stream().toArray(URL[]::new);
            try (URLClassLoader cl = new URLClassLoader(urls);){
                cl.loadClass(className);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void writeGeneratedFiles(Collection<GeneratedFile> generatedFiles) {
        generatedFiles.forEach(this::writeGeneratedFile);
    }

    protected void writeGeneratedFile(GeneratedFile generatedFile) {
        GeneratedFileWriter writer = new GeneratedFileWriter(this.getOutputDirectory().toPath(), this.getGeneratedSources().toPath(), this.getGeneratedResources().toPath(), this.getGeneratedSources().toPath());
        this.getLogger().info("Generating: " + generatedFile.relativePath());
        writer.write(generatedFile);
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getGeneratedSources() {
        return this.generatedSources;
    }

    public void setGeneratedSources(File generatedSources) {
        this.generatedSources = generatedSources;
    }

    public File getGeneratedResources() {
        return this.generatedResources;
    }

    public Boolean getPersistence() {
        return this.persistence;
    }

    public Boolean getGenerateRules() {
        return this.generateRules;
    }

    public Boolean getGenerateProcesses() {
        return this.generateProcesses;
    }

    public Boolean getGenerateDecisions() {
        return this.generateDecisions;
    }

    public Boolean getGeneratePredictions() {
        return this.generatePredictions;
    }

    private static enum Framework {
        QUARKUS,
        SPRING,
        NONE;

    }
}

