/*
 * Decompiled with CFR 0.152.
 */
package io.github.jmusacchio.kogito.generator.gradle.plugin.extensions;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.gradle.api.Project;

public class KogitoExtension
implements Serializable {
    private File projectDir;
    private Map<String, String> properties;
    private Project project;
    private File outputDirectory;
    private File generatedSources;
    private File generatedResources;
    private boolean persistence;
    private boolean generateRules;
    private boolean generateProcesses;
    private boolean generateDecisions;
    private boolean generatePredictions;
    private boolean autoBuild;

    public KogitoExtension(Project project) {
        this.projectDir = project.getProjectDir();
        this.project = project;
        this.outputDirectory = new File(project.getBuildDir() + "/classes");
        this.generatedSources = new File(project.getBuildDir() + "/generated-sources/kogito/");
        this.generatedResources = new File(project.getBuildDir() + "/generated-resources/kogito/");
        this.persistence = true;
        this.generateRules = true;
        this.generateProcesses = true;
        this.generateDecisions = true;
        this.generatePredictions = true;
        this.autoBuild = true;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir = projectDir;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getGeneratedSources() {
        return this.generatedSources;
    }

    public void setGeneratedSources(File generatedSources) {
        this.generatedSources = generatedSources;
    }

    public File getGeneratedResources() {
        return this.generatedResources;
    }

    public void setGeneratedResources(File generatedResources) {
        this.generatedResources = generatedResources;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public void setPersistence(boolean persistence) {
        this.persistence = persistence;
    }

    public boolean isGenerateRules() {
        return this.generateRules;
    }

    public void setGenerateRules(boolean generateRules) {
        this.generateRules = generateRules;
    }

    public boolean isGenerateProcesses() {
        return this.generateProcesses;
    }

    public void setGenerateProcesses(boolean generateProcesses) {
        this.generateProcesses = generateProcesses;
    }

    public boolean isGenerateDecisions() {
        return this.generateDecisions;
    }

    public void setGenerateDecisions(boolean generateDecisions) {
        this.generateDecisions = generateDecisions;
    }

    public boolean isGeneratePredictions() {
        return this.generatePredictions;
    }

    public void setGeneratePredictions(boolean generatePredictions) {
        this.generatePredictions = generatePredictions;
    }

    public boolean isAutoBuild() {
        return this.autoBuild;
    }

    public void setAutoBuild(boolean autoBuild) {
        this.autoBuild = autoBuild;
    }
}

