/*
 * Decompiled with CFR 0.152.
 */
package io.github.jmusacchio.kogito.generator.gradle.plugin;

import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.GenerateModelExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.KogitoExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.extensions.ProcessClassesExtension;
import io.github.jmusacchio.kogito.generator.gradle.plugin.tasks.GenerateModelTask;
import io.github.jmusacchio.kogito.generator.gradle.plugin.tasks.KogitoCompileTask;
import io.github.jmusacchio.kogito.generator.gradle.plugin.tasks.ProcessClassesTask;
import io.github.jmusacchio.kogito.generator.gradle.plugin.tasks.ScaffoldTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;

public class KogitoPlugin
implements Plugin<Project> {
    static final String GROUP = "kogito generator";
    static final String KOGITO_EXTENSION = "kogito";
    static final String GENERATE_MODEL_TASK = "kogitoGenerateModel";
    static final String PROCESS_CLASSES_TASK = "kogitoProcessClasses";
    static final String COMPILE_KOGITO_TASK = "compileKogito";
    static final String SCAFFOLD_TASK = "kogitoScaffold";

    public void apply(Project project) {
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            KogitoExtension extension = (KogitoExtension)project.getExtensions().create(KOGITO_EXTENSION, KogitoExtension.class, new Object[]{project});
            GenerateModelExtension generateModelExtension = (GenerateModelExtension)project.getExtensions().create(GENERATE_MODEL_TASK, GenerateModelExtension.class, new Object[]{project});
            ProcessClassesExtension processClassesExtension = (ProcessClassesExtension)project.getExtensions().create(PROCESS_CLASSES_TASK, ProcessClassesExtension.class, new Object[0]);
            project.afterEvaluate(p -> {
                Task compile = (Task)project.getTasks().named("compileJava").getOrNull();
                if (compile != null) {
                    project.getTasks().register(GENERATE_MODEL_TASK, GenerateModelTask.class, new Object[]{extension, generateModelExtension}).configure(task -> {
                        task.setGroup(GROUP);
                        task.setDescription("Generates code via Kogito Application Generator API for supported kogito specification documents like bpmn, dmn, drl, etc");
                        task.dependsOn(new Object[]{compile});
                    });
                    project.getTasks().register(SCAFFOLD_TASK, ScaffoldTask.class, new Object[]{extension, generateModelExtension}).configure(task -> {
                        task.setGroup(GROUP);
                        task.setDescription("Similar to kogitoGenerateModel task but placing generated java classes on project main java source directory");
                        task.dependsOn(new Object[]{compile});
                    });
                    project.getTasks().register(PROCESS_CLASSES_TASK, ProcessClassesTask.class, new Object[]{extension, processClassesExtension, compile}).configure(task -> {
                        task.setGroup(GROUP);
                        task.setDescription("Generates persistence code via Kogito Persistence Generator API for supported kogito persistence types like jdbc, mongodb, kafka, etc");
                    });
                    project.getTasks().register(COMPILE_KOGITO_TASK, KogitoCompileTask.class, new Object[]{extension, compile}).configure(task -> {
                        task.setGroup(GROUP);
                        task.setDescription("Compiles kogito generated code");
                    });
                    Task generateModel = project.getTasks().findByPath(GENERATE_MODEL_TASK);
                    Task processClasses = project.getTasks().findByPath(PROCESS_CLASSES_TASK);
                    Task compileGenerate = project.getTasks().findByPath(COMPILE_KOGITO_TASK);
                    processClasses.dependsOn(new Object[]{compileGenerate});
                    compileGenerate.finalizedBy(new Object[]{processClasses});
                    if (extension.isAutoBuild()) {
                        compile.finalizedBy(new Object[]{generateModel});
                        generateModel.finalizedBy(new Object[]{compileGenerate});
                        project.getTasks().named("classes").configure(classes -> classes.mustRunAfter(new Object[]{compileGenerate}));
                    }
                }
            });
        });
    }
}

