/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.async.future.impl;

import io.github.jklingsporn.vertx.jooq.async.future.AsyncJooqSQLClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.asyncsql.AsyncSQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.UpdateResult;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.escoffier.vertx.completablefuture.VertxCompletableFuture;
import org.jooq.Param;
import org.jooq.Query;

public class AsyncJooqSQLClientImpl
implements AsyncJooqSQLClient {
    private final Vertx vertx;
    private final AsyncSQLClient delegate;

    public AsyncJooqSQLClientImpl(Vertx vertx, AsyncSQLClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public <P> CompletableFuture<List<P>> fetch(Query query, Function<JsonObject, P> mapper) {
        return this.getConnection().thenCompose(sqlConnection -> {
            VertxCompletableFuture cf = new VertxCompletableFuture(this.vertx);
            sqlConnection.queryWithParams(query.getSQL(), this.getBindValues(query), this.executeAndClose((Function)rs -> rs.getRows().stream().map(mapper).collect(Collectors.toList()), (SQLConnection)sqlConnection, (CompletableFuture)cf));
            return cf;
        });
    }

    @Override
    public <P> CompletableFuture<P> fetchOne(Query query, Function<JsonObject, P> mapper) {
        return this.getConnection().thenCompose(sqlConnection -> {
            VertxCompletableFuture cf = new VertxCompletableFuture(this.vertx);
            sqlConnection.queryWithParams(query.getSQL(), this.getBindValues(query), this.executeAndClose((Function)rs -> {
                Optional optional = rs.getRows().stream().findFirst().map(mapper);
                return optional.orElseGet(() -> null);
            }, (SQLConnection)sqlConnection, (CompletableFuture)cf));
            return cf;
        });
    }

    @Override
    public CompletableFuture<Integer> execute(Query query) {
        return this.getConnection().thenCompose(sqlConnection -> {
            VertxCompletableFuture cf = new VertxCompletableFuture(this.vertx);
            JsonArray bindValues = this.getBindValues(query);
            sqlConnection.updateWithParams(query.getSQL(), bindValues, this.executeAndClose((Function)UpdateResult::getUpdated, (SQLConnection)sqlConnection, (CompletableFuture)cf));
            return cf;
        });
    }

    private JsonArray getBindValues(Query query) {
        JsonArray bindValues = new JsonArray();
        for (Param param : query.getParams().values()) {
            Object value = AsyncJooqSQLClientImpl.convertToDatabaseType(param);
            if (value == null) {
                bindValues.addNull();
                continue;
            }
            bindValues.add(value);
        }
        return bindValues;
    }

    static <T> Object convertToDatabaseType(Param<T> param) {
        return param.getBinding().converter().to(param.getValue());
    }

    private CompletableFuture<SQLConnection> getConnection() {
        VertxCompletableFuture cf = new VertxCompletableFuture(this.vertx);
        this.delegate.getConnection(arg_0 -> AsyncJooqSQLClientImpl.lambda$getConnection$6((CompletableFuture)cf, arg_0));
        return cf;
    }

    private <P, U> Handler<AsyncResult<U>> executeAndClose(Function<U, P> func, SQLConnection sqlConnection, CompletableFuture<P> cf) {
        return rs -> {
            try {
                if (rs.succeeded()) {
                    cf.complete(func.apply(rs.result()));
                } else {
                    cf.completeExceptionally(rs.cause());
                }
            }
            finally {
                sqlConnection.close();
            }
        };
    }

    @Override
    public AsyncSQLClient delegate() {
        return this.delegate;
    }

    private static /* synthetic */ void lambda$getConnection$6(CompletableFuture cf, AsyncResult h) {
        if (h.succeeded()) {
            cf.complete(h.result());
        } else {
            cf.completeExceptionally(h.cause());
        }
    }
}

