/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil.log;

import android.app.Application;
import android.os.Environment;
import android.util.Log;
import com.moyun365.commonutil.log.Config;
import com.moyun365.commonutil.log.Dateformater;
import com.moyun365.commonutil.log.GlobalExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class LogUtil {
    public static final String TAG = "jife";
    public static boolean logON = false;
    public static int level = 6;

    public static void setLogON(boolean logON) {
        LogUtil.logON = logON;
    }

    public static void trace(int type, String tag, String msg) {
        if (logON) {
            switch (type) {
                case 2: {
                    Log.v((String)tag, (String)msg);
                    break;
                }
                case 3: {
                    Log.d((String)tag, (String)msg);
                    break;
                }
                case 4: {
                    Log.i((String)tag, (String)msg);
                    break;
                }
                case 5: {
                    Log.w((String)tag, (String)msg);
                    break;
                }
                case 6: {
                    Log.e((String)tag, (String)msg);
                }
            }
        }
        if (type >= level) {
            LogUtil.writeLog(type, msg);
        }
    }

    public static void v(String tag, String msg) {
        if (logON) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void w(String tag, String msg) {
        if (logON) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg) {
        if (logON) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void d(String tag, String msg) {
        if (logON) {
            Log.d((String)tag, (String)msg);
        }
    }

    private static void writeLog(int type, String msg) {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return;
        }
        try {
            HashMap<Integer, String> logMap = new HashMap<Integer, String>();
            logMap.put(2, " VERBOSE ");
            logMap.put(3, " DEBUG ");
            logMap.put(4, " INFO ");
            logMap.put(5, " WARN ");
            logMap.put(6, " ERROR ");
            StackTraceElement tag = new Throwable().fillInStackTrace().getStackTrace()[2];
            msg = "\r\n" + LogUtil.getDateformat(Dateformater.SS.getValue()) + (String)logMap.get(type) + tag.getClassName() + " - " + tag.getMethodName() + "(): " + msg;
            String fileName = new StringBuffer().append("test-").append(LogUtil.getDateformat(Dateformater.DD.getValue())).append(".log").toString();
            LogUtil.recordLog(Config.LOG_DIR, fileName, msg, true);
        }
        catch (Exception e) {
            LogUtil.trace(6, "LogUtil: ", e.getMessage());
        }
    }

    private static void recordLog(String logDir, String fileName, String msg, boolean bool) {
        try {
            LogUtil.createDir(logDir);
            File saveFile = new File(new StringBuffer().append(logDir).append("/").append(fileName).toString());
            if (!bool && saveFile.exists()) {
                saveFile.delete();
                saveFile.createNewFile();
                FileOutputStream fos = new FileOutputStream(saveFile, bool);
                fos.write(msg.getBytes());
                fos.close();
            } else if (bool && saveFile.exists()) {
                FileOutputStream fos = new FileOutputStream(saveFile, bool);
                fos.write(msg.getBytes());
                fos.close();
            } else if (bool && !saveFile.exists()) {
                saveFile.createNewFile();
                FileOutputStream fos = new FileOutputStream(saveFile, bool);
                fos.write(msg.getBytes());
                fos.close();
            }
        }
        catch (IOException e) {
            LogUtil.recordLog(logDir, fileName, msg, bool);
        }
    }

    public static void processGlobalException(Application application) {
        if (application != null) {
            GlobalExceptionHandler handler = new GlobalExceptionHandler(application);
            Thread.setDefaultUncaughtExceptionHandler(handler);
        }
    }

    private static String getDateformat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date());
    }

    private static File createDir(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

